/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.provider.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.sec.AuthenticationException;
import org.eclipse.scada.sec.AuthenticationService;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.UserManagerService;
import org.eclipse.scada.sec.authn.CredentialsRequest;
import org.eclipse.scada.sec.utils.password.PasswordEncoder;
import org.eclipse.scada.sec.utils.password.PasswordEncoding;
import org.eclipse.scada.sec.utils.password.PasswordType;
import org.eclipse.scada.sec.utils.password.PasswordValidator;
import org.eclipse.scada.utils.collection.MapBuilder;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.jdbc.DataSourceConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.DataSourceFactoryTracker;
import org.eclipse.scada.utils.osgi.jdbc.data.RowMapper;
import org.eclipse.scada.utils.osgi.jdbc.data.RowMapperAdapter;
import org.eclipse.scada.utils.osgi.jdbc.data.RowMapperMappingException;
import org.eclipse.scada.utils.osgi.jdbc.task.CommonConnectionTask;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionContext;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionTask;
import org.eclipse.scada.utils.osgi.jdbc.task.RowCallback;
import org.eclipse.scada.utils.statuscodes.SeverityLevel;
import org.eclipse.scada.utils.statuscodes.StatusCode;
import org.eclipse.scada.utils.str.StringHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcAuthenticationService
implements AuthenticationService,
UserManagerService {
    private static final StatusCode NO_ACCESSOR = new StatusCode("OSSEC", "JDBC", 1L, SeverityLevel.ERROR);
    private static final StatusCode INTERNAL_ERROR = new StatusCode("OSSEC", "JDBC", 2L, SeverityLevel.ERROR);
    private static final Logger logger = LoggerFactory.getLogger(JdbcAuthenticationService.class);
    private final String id;
    private final BundleContext context;
    private String driver;
    private DataSourceFactoryTracker tracker;
    private Properties connectionProperties;
    private DataSourceConnectionAccessor accessor;
    private final ReadWriteLock accessorLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.accessorLock.readLock();
    private final Lock writeLock = this.accessorLock.writeLock();
    private boolean authoritative;
    private PasswordValidator passwordValidator;
    private String findUserSql;
    private String findRolesForUserSql;
    private String updatePasswordSql;
    private PasswordEncoder passwordEncoder;
    private String userIdColumnName;
    private String passwordColumnName;

    public JdbcAuthenticationService(BundleContext context, String id) {
        this.context = context;
        this.id = id;
    }

    public void joinRequest(CredentialsRequest request) {
        request.askUsername();
        request.askPassword(this.passwordValidator.getSupportedInputEncodings());
    }

    public UserInformation authenticate(final CredentialsRequest request) throws AuthenticationException {
        final String username = request.getUserName();
        try {
            this.readLock.lock();
            if (this.accessor == null) {
                logger.info("We don't have any accessor");
                UserInformation userInformation = this.failure("No connection to database", NO_ACCESSOR);
                return userInformation;
            }
            UserInformation userInformation = (UserInformation)this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<UserInformation>(){

                public UserInformation performTask(ConnectionContext connection) throws Exception {
                    return JdbcAuthenticationService.this.performAuthentication(connection, username, request.getPasswords());
                }
            });
            return userInformation;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected UserInformation performAuthentication(ConnectionContext connection, String username, Map<PasswordEncoding, String> passwords) throws AuthenticationException, SQLException {
        PasswordCheckRowCallback callback = new PasswordCheckRowCallback(passwords, this.passwordColumnName, this.userIdColumnName);
        connection.query((RowCallback)callback, this.findUserSql, new MapBuilder().put((Object)"USER_ID", (Object)username).getMap());
        if (!callback.isResult()) {
            return null;
        }
        String userId = this.userIdColumnName != null ? callback.getUserId() : username;
        logger.trace("Using user id: {}", (Object)userId);
        List roles = this.findRolesForUserSql != null && !this.findRolesForUserSql.isEmpty() ? connection.queryForList(String.class, this.findRolesForUserSql, new MapBuilder().put((Object)"USER_ID", (Object)userId).getMap()) : null;
        logger.trace("Found roles for user: {}", roles);
        return new UserInformation(username, roles);
    }

    protected boolean validatePassword(Map<PasswordEncoding, String> providedPasswords, String storedPassword) {
        try {
            return this.passwordValidator.validatePassword(providedPasswords, storedPassword);
        }
        catch (Exception e) {
            logger.warn("Failed to validate password", (Throwable)e);
            return false;
        }
    }

    private UserInformation failure(String message, StatusCode statusCode) throws AuthenticationException {
        if (this.authoritative) {
            throw new AuthenticationException(statusCode, message);
        }
        logger.warn("Failed to authenticate non-authoritative with error: {}", (Object)statusCode);
        return null;
    }

    public void dispose() {
        this.detach();
    }

    public UserInformation getUser(final String username) {
        this.readLock.lock();
        try {
            if (this.accessor == null) {
                logger.info("We don't have any accessor");
                return null;
            }
            UserInformation userInformation = (UserInformation)this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<UserInformation>(){

                public UserInformation performTask(ConnectionContext connection) throws Exception {
                    return JdbcAuthenticationService.this.performLookup(connection, username);
                }
            });
            return userInformation;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected UserInformation performLookup(ConnectionContext connection, String username) throws SQLException {
        List entries = connection.query((RowMapper)new RowMapperAdapter<String>(){

            public String mapRow(ResultSet resultSet) throws SQLException, RowMapperMappingException {
                if (JdbcAuthenticationService.this.userIdColumnName == null) {
                    return "";
                }
                return resultSet.getString(JdbcAuthenticationService.this.userIdColumnName);
            }
        }, this.findUserSql, new MapBuilder().put((Object)"USER_ID", (Object)username).getMap());
        if (entries.isEmpty()) {
            return null;
        }
        String userId = this.userIdColumnName != null ? (String)entries.get(0) : username;
        logger.trace("Using '{0}' as user id", (Object)userId);
        List roles = this.findRolesForUserSql != null && !this.findRolesForUserSql.isEmpty() ? connection.queryForList(String.class, this.findRolesForUserSql, new MapBuilder().put((Object)"USER_ID", (Object)userId).getMap()) : null;
        logger.trace("Found roles for user: {}", roles);
        return new UserInformation(userId, roles);
    }

    public void update(Map<String, String> parameters) throws Exception {
        logger.debug("Updating configuration");
        this.detach();
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        this.driver = cfg.getStringChecked("driver", "Need database driver name in 'driver'");
        this.connectionProperties = new Properties();
        this.connectionProperties.putAll((Map<?, ?>)cfg.getPrefixed("jdbc.properties."));
        PasswordType passwordType = (PasswordType)cfg.getEnumChecked("passwordType", PasswordType.class, String.format("Need 'passwordType' to be one of (%s)", StringHelper.join((Object[])PasswordType.values(), (String)", ")));
        this.passwordValidator = passwordType.createValdiator();
        this.passwordEncoder = passwordType.createEncoder();
        this.authoritative = cfg.getBoolean("authoritative", true);
        this.findUserSql = cfg.getStringChecked("findUserSql", "Need 'findUserSql' to be set");
        this.findRolesForUserSql = cfg.getString("findRolesForUserSql");
        this.updatePasswordSql = cfg.getString("updatePasswordSql");
        this.userIdColumnName = cfg.getString("userIdColumnName");
        this.passwordColumnName = cfg.getString("passwordColumnName", "password");
        this.attach();
    }

    private void attach() throws InvalidSyntaxException {
        logger.debug("Creating data source tracker: {}", (Object)this.driver);
        this.tracker = new DataSourceFactoryTracker(this.context, this.driver, (SingleServiceListener)new SingleServiceListener<DataSourceFactory>(){

            public void serviceChange(ServiceReference<DataSourceFactory> reference, DataSourceFactory service) {
                JdbcAuthenticationService.this.setDataSource(service);
            }
        });
        this.tracker.open();
    }

    private void detach() {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
    }

    protected void setDataSource(DataSourceFactory service) {
        logger.debug("Setting data source: {}", (Object)service);
        try {
            this.writeLock.lock();
            if (this.accessor != null) {
                this.accessor.dispose();
                this.accessor = null;
            }
            try {
                if (service != null) {
                    this.accessor = new DataSourceConnectionAccessor(service, this.connectionProperties);
                }
            }
            catch (SQLException e) {
                logger.error("Failed to create datasource for " + this.id, (Throwable)e);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isUserManager() {
        return this.updatePasswordSql != null && !this.updatePasswordSql.isEmpty();
    }

    public void setPassword(final String user, final String password) {
        try {
            this.readLock.lock();
            if (this.accessor == null) {
                logger.info("We don't have any accessor");
                throw new IllegalStateException("User manager does not have a database connection");
            }
            this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<Void>(){

                protected Void performTask(ConnectionContext connection) throws Exception {
                    connection.setAutoCommit(false);
                    JdbcAuthenticationService.this.handleSetPassword(connection, user, password);
                    connection.commit();
                    return null;
                }
            });
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected void handleSetPassword(ConnectionContext connection, String user, String password) throws Exception {
        String encodedPassword = this.passwordEncoder.encodePassword(password);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("USER_NAME", user);
        parameters.put("PASSWORD", encodedPassword);
        int count = connection.update(this.updatePasswordSql, new Object[]{parameters});
        logger.info("Updated password for user {} => {}", (Object)user, (Object)count);
        if (count != 1) {
            throw new IllegalStateException(count < 1 ? String.format("User '%s' was not found", user) : "Too many entries");
        }
    }

    public class PasswordCheckRowCallback
    implements RowCallback {
        private boolean result;
        private final Map<PasswordEncoding, String> passwords;
        private final String userIdColumnName;
        private String userId;
        private final String passwordColumnName;

        public PasswordCheckRowCallback(Map<PasswordEncoding, String> passwords, String passwordColumnName, String userIdColumnName) {
            this.passwords = passwords;
            this.userIdColumnName = userIdColumnName;
            this.passwordColumnName = passwordColumnName;
        }

        public boolean isResult() {
            return this.result;
        }

        public String getUserId() {
            return this.userId;
        }

        public void processRow(ResultSet resultSet) throws SQLException {
            String storedPassword = resultSet.getString(this.passwordColumnName);
            if (storedPassword == null || storedPassword.isEmpty()) {
                return;
            }
            if (JdbcAuthenticationService.this.validatePassword(this.passwords, storedPassword)) {
                if (this.userIdColumnName != null) {
                    this.userId = resultSet.getString(this.userIdColumnName);
                }
                this.result = true;
            }
        }
    }
}

