/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.rest.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.da.server.exporter.common.HiveSource;
import org.eclipse.scada.da.server.exporter.common.ServiceListenerHiveSource;
import org.eclipse.scada.da.server.exporter.rest.internal.DataContext;
import org.eclipse.scada.da.server.exporter.rest.internal.DataContextProvider;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.concurrent.ScheduledExportedExecutorService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationFactoryImpl
implements ConfigurationFactory,
DataContextProvider {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationFactoryImpl.class);
    private final Map<String, DataContext> contextMap = new HashMap<String, DataContext>();
    private final Lock readLock;
    private final Lock writeLock;
    private final ScheduledExecutorService executor;
    private final ServiceListenerHiveSource hiveSource;

    public ConfigurationFactoryImpl() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        BundleContext context = FrameworkUtil.getBundle(DataContext.class).getBundleContext();
        this.executor = new ScheduledExportedExecutorService("org.eclipse.scada.da.server.exporter.rest", 1);
        this.hiveSource = new ServiceListenerHiveSource(context, (Executor)this.executor);
        this.hiveSource.open();
    }

    @Override
    public DataContext getContext(String contextId) {
        this.readLock.lock();
        try {
            DataContext dataContext = this.contextMap.get(contextId);
            return dataContext;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void update(UserInformation userInformation, String configurationId, Map<String, String> properties) throws Exception {
        DataContext oldContext;
        DataContext context = new DataContext(this.executor, (HiveSource)this.hiveSource, properties);
        this.writeLock.lock();
        try {
            oldContext = this.contextMap.put(configurationId, context);
        }
        finally {
            this.writeLock.unlock();
        }
        if (oldContext != null) {
            oldContext.dispose();
        }
    }

    public void delete(UserInformation userInformation, String configurationId) throws Exception {
        DataContext oldContext;
        this.writeLock.lock();
        try {
            oldContext = this.contextMap.remove(configurationId);
        }
        finally {
            this.writeLock.unlock();
        }
        if (oldContext != null) {
            oldContext.dispose();
        }
    }

    public void dispose() {
        ArrayList<DataContext> disposeList;
        logger.info("Disposing ... ");
        this.writeLock.lock();
        try {
            disposeList = new ArrayList<DataContext>(this.contextMap.size());
            disposeList.addAll(this.contextMap.values());
            this.contextMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
        for (DataContext context : disposeList) {
            context.dispose();
        }
        this.hiveSource.close();
        this.executor.shutdown();
    }
}

