/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.master;

import com.google.common.collect.Interner;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.eclipse.scada.ca.Configuration;
import org.eclipse.scada.ca.ConfigurationAdministrator;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.core.WriteAttributeResult;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.master.AbstractMasterHandlerImpl;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.da.master.WriteRequest;
import org.eclipse.scada.da.master.WriteRequestResult;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigurableMasterHandlerImpl
extends AbstractMasterHandlerImpl {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConfigurableMasterHandlerImpl.class);
    private final String prefix;
    private final ServiceTracker<ConfigurationAdministrator, ConfigurationAdministrator> tracker;
    private final String factoryId;
    private final String configurationId;
    private final String dotPrefix;
    private final int dotPrefixLength;

    public AbstractConfigurableMasterHandlerImpl(String configurationId, ObjectPoolTracker<MasterItem> poolTracker, int priority, ServiceTracker<ConfigurationAdministrator, ConfigurationAdministrator> caTracker, String prefix, String factoryId) {
        super(poolTracker, priority);
        this.configurationId = configurationId;
        this.tracker = caTracker;
        this.prefix = prefix;
        this.factoryId = factoryId;
        this.dotPrefix = String.valueOf(this.prefix) + ".";
        this.dotPrefixLength = this.dotPrefix.length();
    }

    protected String getPrefixed(String id, Interner<String> stringInterner) {
        if (id == null) {
            return this.prefix;
        }
        return (String)stringInterner.intern((Object)(String.valueOf(this.dotPrefix) + id));
    }

    @Override
    public WriteRequestResult processWrite(WriteRequest request) {
        if (request.getAttributes() == null) {
            return null;
        }
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        for (Map.Entry<String, Variant> entry : request.getAttributes().entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(this.dotPrefix)) continue;
            attributes.put(key.substring(this.dotPrefixLength), entry.getValue());
        }
        if (attributes.isEmpty()) {
            return null;
        }
        try {
            WriteAttributeResults result = this.handleUpdate(Collections.unmodifiableMap(attributes), request.getOperationParameters());
            for (String attr : result.keySet()) {
                attributes.remove(attr);
            }
            for (String attr : attributes.keySet()) {
                result.put((Object)attr, (Object)new WriteAttributeResult((Throwable)new OperationException(String.format("Attribute '%s' is not supported", String.valueOf(this.dotPrefix) + attr))));
            }
            HashMap<String, Variant> newAttributes = new HashMap<String, Variant>(request.getAttributes());
            WriteAttributeResults fullResults = new WriteAttributeResults();
            for (Map.Entry entry : result.entrySet()) {
                String fullKey = String.valueOf(this.dotPrefix) + (String)entry.getKey();
                fullResults.put((Object)fullKey, (Object)((WriteAttributeResult)entry.getValue()));
                newAttributes.remove(fullKey);
            }
            return new WriteRequestResult(request.getValue(), newAttributes, fullResults);
        }
        catch (Throwable e) {
            return new WriteRequestResult(e);
        }
    }

    protected abstract WriteAttributeResults handleUpdate(Map<String, Variant> var1, OperationParameters var2) throws Exception;

    protected WriteAttributeResults updateConfiguration(Map<String, String> data, Map<String, Variant> attributes, boolean fullSet, OperationParameters operationParameters) throws OperationException {
        return this.updateConfiguration(data, attributes, fullSet, operationParameters, null);
    }

    protected WriteAttributeResults updateConfiguration(Map<String, String> data, Map<String, Variant> attributes, boolean fullSet, OperationParameters operationParameters, WriteAttributeResults result) throws OperationException {
        if (result == null) {
            result = new WriteAttributeResults();
        }
        if (data.isEmpty()) {
            return result;
        }
        ConfigurationAdministrator service = (ConfigurationAdministrator)this.tracker.getService();
        if (!(service instanceof ConfigurationAdministrator)) {
            logger.info("Unable to set attributes - Configuration administrator not available");
            OperationException error = new OperationException("Configuration administrator not available");
            for (String attr : data.keySet()) {
                result.put((Object)attr, (Object)new WriteAttributeResult((Throwable)error));
            }
            return result;
        }
        for (String attr : data.keySet()) {
            if (!attributes.containsKey(attr)) continue;
            result.put((Object)attr, (Object)WriteAttributeResult.OK);
        }
        NotifyFuture future = service.updateConfiguration(operationParameters.getUserInformation(), this.factoryId, this.configurationId, data, fullSet);
        future.addListener((FutureListener)new FutureListener<Configuration>(){

            public void complete(Future<Configuration> future) {
                try {
                    logger.info("Completed applying: {}", (Object)future.get());
                }
                catch (Exception e) {
                    logger.warn("Failed applying", (Throwable)e);
                }
            }
        });
        return result;
    }
}

