/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.master.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.base.AbstractDataSourceHandler;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.da.master.MasterItemHandler;
import org.eclipse.scada.da.master.WriteRequest;
import org.eclipse.scada.da.master.WriteRequestResult;
import org.eclipse.scada.utils.concurrent.AbstractFuture;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterItemImpl
extends AbstractDataSourceHandler
implements MasterItem {
    private static final boolean LOG_SUPPRESS = Boolean.getBoolean("org.eclipse.scada.da.master.internal.masterItemLogSuppressProcess");
    private static final Logger logger = LoggerFactory.getLogger(MasterItemImpl.class);
    private volatile DataItemValue sourceValue;
    private final List<HandlerEntry> itemHandler = new LinkedList<HandlerEntry>();
    private final Executor executor;
    private String dataSourceId;
    private boolean debug = false;
    private boolean dontOverrideSubscription = false;
    private final Lock processTriggerLock = new ReentrantLock();
    private boolean processTriggered;
    private final Runnable processRunnable = new Runnable(){

        @Override
        public void run() {
            MasterItemImpl.this.doReprocess();
        }
    };
    private final String id;

    public MasterItemImpl(Executor executor, BundleContext context, String id, ObjectPoolTracker<DataSource> dataSourcePoolTracker) throws InvalidSyntaxException {
        super(dataSourcePoolTracker);
        this.id = id;
        this.executor = executor;
        this.stateChanged(MasterItemImpl.initValue());
    }

    private static DataItemValue initValue() {
        DataItemValue.Builder builder = new DataItemValue.Builder();
        builder.setAttribute("master.uninitialized", Variant.TRUE);
        return builder.build();
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List<HandlerEntry> list = this.itemHandler;
        synchronized (list) {
            this.itemHandler.clear();
        }
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHandler(MasterItemHandler handler, int priority) {
        List<HandlerEntry> list = this.itemHandler;
        synchronized (list) {
            logger.debug("Adding handler: {}/{}", new Object[]{handler, priority});
            HandlerEntry entry = new HandlerEntry(handler, priority);
            if (this.itemHandler.contains(entry)) {
                return;
            }
            this.itemHandler.add(entry);
            Collections.sort(this.itemHandler);
            logger.debug("Added handler: {}/{}", new Object[]{handler, priority});
        }
        this.reprocess();
    }

    @Override
    public void reprocess() {
        try {
            this.processTriggerLock.lock();
            if (this.processTriggered) {
                if (LOG_SUPPRESS) {
                    logger.trace("Suppressed process()");
                }
                return;
            }
            this.processTriggered = true;
            this.executor.execute(this.processRunnable);
        }
        finally {
            this.processTriggerLock.unlock();
        }
    }

    protected void doReprocess() {
        try {
            this.processTriggerLock.lock();
            this.processTriggered = false;
        }
        finally {
            this.processTriggerLock.unlock();
        }
        this.handleProcess();
    }

    protected synchronized void handleProcess() {
        logger.debug("Reprocessing");
        this.updateData(this.processHandler(this.sourceValue));
    }

    protected synchronized void stateChanged(DataItemValue value) {
        logger.debug("state change: {}", (Object)value);
        if (value != null) {
            if (value.isConnected() || this.dontOverrideSubscription) {
                this.sourceValue = value;
            } else {
                DataItemValue.Builder builder = new DataItemValue.Builder(value);
                builder.setSubscriptionState(SubscriptionState.CONNECTED);
                this.sourceValue = builder.build();
            }
        } else {
            DataItemValue.Builder builder = new DataItemValue.Builder();
            builder.setAttribute("master.source.error", Variant.TRUE);
            builder.setAttribute("master.datasource.id", Variant.valueOf((Object)this.dataSourceId));
            this.sourceValue = builder.build();
        }
        this.reprocess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHandler(MasterItemHandler handler) {
        List<HandlerEntry> list = this.itemHandler;
        synchronized (list) {
            logger.debug("Before - Handlers: {}", (Object)this.itemHandler.size());
            if (this.itemHandler.remove(new HandlerEntry(handler, 0))) {
                logger.debug("Removed handler: {}", (Object)handler);
                this.reprocess();
            }
            logger.debug("After - Handlers: {}", (Object)this.itemHandler.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataItemValue processHandler(DataItemValue value) {
        ArrayList<HandlerEntry> handler;
        logger.debug("Processing handlers");
        List<HandlerEntry> list = this.itemHandler;
        synchronized (list) {
            handler = new ArrayList<HandlerEntry>(this.itemHandler);
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        DataItemValue.Builder builder = new DataItemValue.Builder(value);
        for (HandlerEntry entry : handler) {
            logger.debug("Process: {} -> {}", new Object[]{entry.getPriority(), entry.getHandler()});
            entry.getHandler().dataUpdate(context, builder);
        }
        if (this.debug) {
            builder.setAttribute("master.debug.handlerCount", Variant.valueOf((int)handler.size()));
            value = builder.build();
        }
        return builder.build();
    }

    public synchronized NotifyFuture<WriteResult> startWriteValue(Variant value, OperationParameters operationParameters) {
        WriteListenerValueImpl task = new WriteListenerValueImpl();
        this.processWrite(new WriteRequest(value, operationParameters), task);
        return task;
    }

    public synchronized NotifyFuture<WriteAttributeResults> startWriteAttributes(Map<String, Variant> attributes, OperationParameters operationParameters) {
        WriteListenerAttributeImpl task = new WriteListenerAttributeImpl();
        this.processWrite(new WriteRequest(attributes, operationParameters), task);
        return task;
    }

    private void processWrite(WriteRequest writeRequest, final WriteListener listener) {
        DataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            listener.error(new OperationException("No connection").fillInStackTrace());
            return;
        }
        try {
            Map<String, Variant> attributes;
            final WriteRequestResult result = this.preProcessWrite(writeRequest);
            Throwable error = result.getError();
            if (error != null) {
                listener.error(error);
                return;
            }
            Variant value = result.getValue();
            if (value != null) {
                NotifyFuture task = dataSource.startWriteValue(value, writeRequest.getOperationParameters());
                task.addListener((FutureListener)new FutureListener<WriteResult>(){

                    public void complete(Future<WriteResult> future) {
                        try {
                            listener.complete(future.get());
                        }
                        catch (Throwable e) {
                            logger.info("Failed to write value", e);
                            listener.error(e);
                        }
                    }
                });
            }
            if (!(attributes = result.getAttributes()).isEmpty()) {
                NotifyFuture task = dataSource.startWriteAttributes(attributes, writeRequest.getOperationParameters());
                task.addListener((FutureListener)new FutureListener<WriteAttributeResults>(){

                    public void complete(Future<WriteAttributeResults> future) {
                        try {
                            listener.complete(MasterItemImpl.this.mergeResults(result.getAttributeResults(), future.get()));
                        }
                        catch (Throwable e) {
                            logger.info("Failed to write attributes", e);
                            listener.error(e);
                        }
                    }
                });
            } else if (!result.getAttributeResults().isEmpty()) {
                listener.complete(result.getAttributeResults());
            }
        }
        catch (Throwable e) {
            logger.info("Failed to write to master item", e);
            listener.error(e);
        }
    }

    protected WriteAttributeResults mergeResults(WriteAttributeResults firstResult, WriteAttributeResults secondResult) {
        WriteAttributeResults newResults = new WriteAttributeResults();
        if (firstResult != null) {
            newResults.putAll((Map)firstResult);
        }
        if (secondResult != null) {
            newResults.putAll((Map)secondResult);
        }
        return newResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WriteRequestResult preProcessWrite(WriteRequest writeRequest) {
        HandlerEntry[] handlers;
        List<HandlerEntry> list = this.itemHandler;
        synchronized (list) {
            handlers = this.itemHandler.toArray(new HandlerEntry[this.itemHandler.size()]);
        }
        WriteRequest request = writeRequest;
        WriteRequestResult finalResult = new WriteRequestResult(writeRequest.getValue(), writeRequest.getAttributes(), null);
        int i = handlers.length;
        while (i > 0) {
            HandlerEntry handler = handlers[i - 1];
            WriteRequestResult nextResult = handler.getHandler().processWrite(request);
            if (nextResult != null) {
                if ((finalResult = MasterItemImpl.mergeNextResult(finalResult, nextResult)).getError() != null) {
                    return finalResult;
                }
                Map<String, Variant> nextAttributes = finalResult.getAttributes();
                for (Map.Entry entry : finalResult.getAttributeResults().entrySet()) {
                    nextAttributes.remove(entry.getKey());
                }
                request = new WriteRequest(finalResult.getValue(), nextAttributes, writeRequest.getOperationParameters());
            }
            --i;
        }
        return finalResult;
    }

    private static WriteRequestResult mergeNextResult(WriteRequestResult finalResult, WriteRequestResult nextResult) {
        if (nextResult.getError() != null) {
            return nextResult;
        }
        WriteAttributeResults result = new WriteAttributeResults();
        if (nextResult.getAttributeResults() != null) {
            result.putAll((Map)nextResult.getAttributeResults());
        }
        if (finalResult.getAttributeResults() != null) {
            result.putAll((Map)finalResult.getAttributeResults());
        }
        return new WriteRequestResult(nextResult.getValue(), nextResult.getAttributes(), result);
    }

    public synchronized void update(Map<String, String> properties) throws InvalidSyntaxException {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(properties);
        this.dataSourceId = cfg.getString("datasource.id");
        this.dontOverrideSubscription = cfg.getBoolean("dontOverrideSubscription", false);
        this.debug = cfg.getBoolean("debug", false);
        this.stateChanged(null);
        this.setDataSource(this.dataSourceId);
    }

    public String toString() {
        return String.format(String.valueOf(this.getClass().getSimpleName()) + ": " + this.id, new Object[0]);
    }

    private static class HandlerEntry
    implements Comparable<HandlerEntry> {
        private final MasterItemHandler handler;
        private final int priority;

        public HandlerEntry(MasterItemHandler handler, int priority) {
            this.handler = handler;
            this.priority = priority;
        }

        public MasterItemHandler getHandler() {
            return this.handler;
        }

        @Override
        public int compareTo(HandlerEntry o) {
            return this.priority < o.priority ? -1 : (this.priority == o.priority ? 0 : 1);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.handler == null ? 0 : this.handler.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HandlerEntry other = (HandlerEntry)obj;
            return !(this.handler == null ? other.handler != null : !this.handler.equals(other.handler));
        }

        public int getPriority() {
            return this.priority;
        }
    }

    private static interface WriteListener {
        public void complete(WriteResult var1);

        public void complete(WriteAttributeResults var1);

        public void failed(String var1);

        public void error(Throwable var1);
    }

    private static class WriteListenerAttributeImpl
    extends AbstractFuture<WriteAttributeResults>
    implements WriteListener {
        private WriteListenerAttributeImpl() {
        }

        @Override
        public void complete(WriteResult result) {
            this.setResult(new WriteAttributeResults());
        }

        @Override
        public void complete(WriteAttributeResults results) {
            this.setResult(results);
        }

        @Override
        public void failed(String error) {
            this.setError(new OperationException(error).fillInStackTrace());
        }

        @Override
        public void error(Throwable error) {
            this.setError(error);
        }
    }

    private static class WriteListenerValueImpl
    extends AbstractFuture<WriteResult>
    implements WriteListener {
        private WriteListenerValueImpl() {
        }

        @Override
        public void complete(WriteResult result) {
            this.setResult(result);
        }

        @Override
        public void complete(WriteAttributeResults results) {
            this.setResult(new WriteResult());
        }

        @Override
        public void failed(String error) {
            this.setError(new OperationException(error).fillInStackTrace());
        }

        @Override
        public void error(Throwable error) {
            this.setError(error);
        }
    }
}

