/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.client.net;

import java.util.List;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.Query;
import org.eclipse.scada.ae.QueryListener;
import org.eclipse.scada.ae.client.net.ConnectionImpl;
import org.eclipse.scada.ae.data.QueryState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryImpl
implements Query {
    private static final Logger logger = LoggerFactory.getLogger(QueryImpl.class);
    private final long queryId;
    private QueryListener listener;
    private final ConnectionImpl connection;

    public QueryImpl(ConnectionImpl connection, long queryId, QueryListener listener) {
        this.connection = connection;
        this.queryId = queryId;
        this.listener = listener;
    }

    public void close() {
        this.connection.closeQuery(this.queryId);
    }

    public void loadMore(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("'count' must be greater than zero");
        }
        this.connection.loadMore(this.queryId, count);
    }

    public void handleStateChange(QueryState state, Throwable error) {
        try {
            this.listener.queryStateChanged(state, error);
        }
        catch (Exception e) {
            logger.warn("Failed to handle state change", (Throwable)e);
        }
    }

    public synchronized void dispose() {
        if (this.listener != null) {
            this.handleStateChange(QueryState.DISCONNECTED, null);
            this.listener = null;
        }
    }

    public void handleData(List<Event> data) {
        try {
            this.listener.queryData(data);
        }
        catch (Exception e) {
            logger.warn("Failed to handle data change", (Throwable)e);
        }
    }
}

