/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.net;

import org.eclipse.scada.ae.server.Service;
import org.eclipse.scada.ae.server.net.Exporter;
import org.eclipse.scada.core.ConnectionInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    private static final Logger logger = LoggerFactory.getLogger(Application.class);

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                System.err.println("syntax: Application <hiveClassName>");
                return;
            }
            ConnectionInformation ci = null;
            if (args.length >= 2) {
                ci = ConnectionInformation.fromURI((String)args[1]);
            }
            if (ci == null) {
                ci = ConnectionInformation.fromURI((String)("ae:net://0.0.0.0:" + System.getProperty("org.eclipse.scada.ae.server.net.serverPort", "1302")));
            }
            Class<?> hiveClass = Class.forName(args[0]);
            Service service = (Service)hiveClass.newInstance();
            Exporter exporter = new Exporter(service, ci);
            service.start();
            exporter.start();
            logger.info("Running exporter (hive class: " + exporter.getServiceClass().getCanonicalName() + ")...");
        }
        catch (Throwable e) {
            logger.error("Error in Eclipse SCADA AE[NET] Server", e);
            System.exit(1);
        }
    }
}

