/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.client.ngp;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.eclipse.scada.ca.client.Connection;
import org.eclipse.scada.ca.client.FactoriesListener;
import org.eclipse.scada.ca.common.ngp.ProtocolConfigurationFactoryImpl;
import org.eclipse.scada.ca.data.ConfigurationInformation;
import org.eclipse.scada.ca.data.DiffEntry;
import org.eclipse.scada.ca.data.FactoryInformation;
import org.eclipse.scada.ca.data.message.ApplyDiffRequest;
import org.eclipse.scada.ca.data.message.ApplyDiffResponse;
import org.eclipse.scada.ca.data.message.ErrorResponse;
import org.eclipse.scada.ca.data.message.GetConfigurationRequest;
import org.eclipse.scada.ca.data.message.GetConfigurationResponse;
import org.eclipse.scada.ca.data.message.GetFactoriesRequest;
import org.eclipse.scada.ca.data.message.GetFactoriesResponse;
import org.eclipse.scada.ca.data.message.GetFactoryWithDataRequest;
import org.eclipse.scada.ca.data.message.GetFactoryWithDataResponse;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.client.ngp.ConnectionBaseImpl;
import org.eclipse.scada.core.data.OperationParameters;
import org.eclipse.scada.core.data.Request;
import org.eclipse.scada.core.data.RequestMessage;
import org.eclipse.scada.core.data.ResponseMessage;
import org.eclipse.scada.protocol.ngp.common.ProtocolConfigurationFactory;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.concurrent.ExecutorFuture;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionImpl
extends ConnectionBaseImpl
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionImpl.class);
    private final Set<FactoriesListener> listeners = new HashSet<FactoriesListener>();
    private FactoryInformation[] factories = new FactoryInformation[0];

    public ConnectionImpl(ConnectionInformation connectionInformation) throws Exception {
        super((ProtocolConfigurationFactory)new ProtocolConfigurationFactoryImpl(connectionInformation), connectionInformation);
    }

    protected void onConnectionBound() {
        super.onConnectionBound();
        this.getFactories().addListener((FutureListener)new FutureListener<FactoryInformation[]>(){

            public void complete(Future<FactoryInformation[]> future) {
                try {
                    ConnectionImpl.this.setFactories(future.get());
                }
                catch (Exception e) {
                    logger.warn("Failed to load initial factories list", (Throwable)e);
                }
            }
        });
    }

    protected void onConnectionClosed() {
        this.setFactories(new FactoryInformation[0]);
        super.onConnectionClosed();
    }

    protected synchronized void setFactories(final FactoryInformation[] factories) {
        this.factories = factories;
        if (!this.isDisposed()) {
            for (final FactoriesListener listener : this.listeners) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.updateFactories(factories);
                    }
                });
            }
        }
    }

    public synchronized void addFactoriesListener(final FactoriesListener listener) {
        if (this.listeners.add(listener)) {
            final FactoryInformation[] factories = this.factories;
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.updateFactories(factories);
                }
            });
        }
    }

    public synchronized void removeFactoriesListener(FactoriesListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized NotifyFuture<FactoryInformation[]> getFactories() {
        logger.debug("Getting all factories");
        return new ErrorAwareFuture<GetFactoriesResponse, FactoryInformation[]>((Executor)this.executor, GetFactoriesResponse.class, this.sendRequestMessage((RequestMessage)new GetFactoriesRequest(this.nextRequest()))){

            @Override
            public FactoryInformation[] handleResponse(GetFactoriesResponse result) {
                return result.getFactories().toArray(new FactoryInformation[result.getFactories().size()]);
            }
        };
    }

    public synchronized NotifyFuture<FactoryInformation> getFactoryWithData(String factoryId) {
        logger.debug("Getting factory: {}", (Object)factoryId);
        return new ErrorAwareFuture<GetFactoryWithDataResponse, FactoryInformation>((Executor)this.executor, GetFactoryWithDataResponse.class, this.sendRequestMessage((RequestMessage)new GetFactoryWithDataRequest(this.nextRequest(), factoryId))){

            @Override
            public FactoryInformation handleResponse(GetFactoryWithDataResponse result) {
                return result.getFactory();
            }
        };
    }

    public synchronized NotifyFuture<ConfigurationInformation> getConfiguration(String factoryId, String configurationId) {
        logger.debug("Getting configuration: {} - {}", (Object)factoryId, (Object)configurationId);
        return new ErrorAwareFuture<GetConfigurationResponse, ConfigurationInformation>((Executor)this.executor, GetConfigurationResponse.class, this.sendRequestMessage((RequestMessage)new GetConfigurationRequest(this.nextRequest(), factoryId, configurationId))){

            @Override
            public ConfigurationInformation handleResponse(GetConfigurationResponse result) {
                return result.getConfiguration();
            }
        };
    }

    public NotifyFuture<Void> applyDiff(List<DiffEntry> changeSet, OperationParameters operationParameters, CallbackHandler callbackHandler) {
        logger.debug("Apply diff: {} changes", (Object)changeSet.size());
        Request request = this.nextRequest();
        Long callbackHandlerId = this.registerCallbackHandler(request, callbackHandler);
        return new ErrorAwareFuture<ApplyDiffResponse, Void>((Executor)this.executor, ApplyDiffResponse.class, this.sendRequestMessage((RequestMessage)new ApplyDiffRequest(request, changeSet, operationParameters, callbackHandlerId))){

            @Override
            public Void handleResponse(ApplyDiffResponse result) {
                return null;
            }
        };
    }

    protected static abstract class ErrorAwareFuture<Res extends ResponseMessage, M>
    extends ExecutorFuture<M> {
        public ErrorAwareFuture(Executor executor, final Class<Res> responseClazz, NotifyFuture<ResponseMessage> listener) {
            super(executor);
            listener.addListener((FutureListener)new FutureListener<ResponseMessage>(){

                public void complete(Future<ResponseMessage> future) {
                    try {
                        ResponseMessage result = future.get();
                        if (responseClazz.isAssignableFrom(result.getClass())) {
                            ErrorAwareFuture.this.asyncSetResult(ErrorAwareFuture.this.handleResponse((ResponseMessage)responseClazz.cast(result)));
                        } else if (result instanceof ErrorResponse) {
                            ErrorAwareFuture.this.asyncSetError((Throwable)new OperationException(((ErrorResponse)result).getErrorInformation().getMessage()));
                        } else {
                            ErrorAwareFuture.this.asyncSetError((Throwable)new OperationException(String.format("Wrong reply in message. Expected: %s, Received: %s", responseClazz.getClass(), result.getClass())));
                        }
                    }
                    catch (Exception e) {
                        ErrorAwareFuture.this.asyncSetError(e);
                    }
                }
            });
        }

        public abstract M handleResponse(Res var1) throws Exception;
    }
}

