/*******************************************************************************
 * Copyright (c) 2010, 2013 TH4 SYSTEMS GmbH and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     TH4 SYSTEMS GmbH - initial API and implementation
 *     Jens Reimann - implement security callback system
 *******************************************************************************/
package org.eclipse.scada.ca.data.message;

public class ApplyDiffRequest implements java.io.Serializable, org.eclipse.scada.core.data.RequestMessage
{
    private static final long serialVersionUID = 1L;

    public ApplyDiffRequest ( final org.eclipse.scada.core.data.Request request, final java.util.List<org.eclipse.scada.ca.data.DiffEntry> diffs, final org.eclipse.scada.core.data.OperationParameters operationParameters, final Long callbackHandlerId )
    {
        this.request = request;
        this.diffs = diffs;
        this.operationParameters = operationParameters;
        this.callbackHandlerId = callbackHandlerId;
    }

    private final org.eclipse.scada.core.data.Request request;

    @Override
    public org.eclipse.scada.core.data.Request getRequest ()
    {
        return this.request;
    }

    private final java.util.List<org.eclipse.scada.ca.data.DiffEntry> diffs;

    public java.util.List<org.eclipse.scada.ca.data.DiffEntry> getDiffs ()
    {
        return this.diffs;
    }

    private final org.eclipse.scada.core.data.OperationParameters operationParameters;

    public org.eclipse.scada.core.data.OperationParameters getOperationParameters ()
    {
        return this.operationParameters;
    }

    private final Long callbackHandlerId;

    public Long getCallbackHandlerId ()
    {
        return this.callbackHandlerId;
    }

    @Override
    public String toString ()
    {
        return "[ApplyDiffRequest - " + "request: " + this.request + ", " + "diffs: " + this.diffs + ", " + "operationParameters: " + this.operationParameters + ", " + "callbackHandlerId: " + this.callbackHandlerId + "]";
    }
}
