/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.ds;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.scada.ca.common.factory.AbstractServiceConfigurationFactory;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.ds.DataStoreDataSource;
import org.eclipse.scada.ds.DataNodeTracker;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreSourceFactory
extends AbstractServiceConfigurationFactory<DataStoreDataSource> {
    private static final Logger logger = LoggerFactory.getLogger(DataStoreSourceFactory.class);
    private final Executor executor;
    private final ObjectPoolImpl<DataSource> objectPool;
    private final ServiceRegistration<?> poolRegistration;
    private final DataNodeTracker dataNodeTracker;

    public DataStoreSourceFactory(BundleContext context, Executor executor, DataNodeTracker dataNodeTracker) throws InvalidSyntaxException {
        super(context);
        this.executor = executor;
        this.dataNodeTracker = dataNodeTracker;
        this.objectPool = new ObjectPoolImpl();
        this.poolRegistration = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.objectPool, DataSource.class);
    }

    public synchronized void dispose() {
        this.poolRegistration.unregister();
        this.objectPool.dispose();
        super.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<DataStoreDataSource> createService(UserInformation userInformation, String configurationId, BundleContext context, Map<String, String> parameters) throws Exception {
        logger.debug("Creating new memory source: {}", (Object)configurationId);
        DataStoreDataSource source = new DataStoreDataSource(context, configurationId, this.executor, this.dataNodeTracker);
        source.update(parameters);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("datasource.id", configurationId);
        this.objectPool.addService(configurationId, (Object)source, properties);
        return new AbstractServiceConfigurationFactory.Entry(configurationId, (Object)source);
    }

    protected void disposeService(UserInformation userInformation, String id, DataStoreDataSource service) {
        logger.info("Disposing: {}", (Object)id);
        this.objectPool.removeService(id, (Object)service);
        service.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<DataStoreDataSource> updateService(UserInformation userInformation, String configurationId, AbstractServiceConfigurationFactory.Entry<DataStoreDataSource> entry, Map<String, String> parameters) throws Exception {
        ((DataStoreDataSource)((Object)entry.getService())).update(parameters);
        return null;
    }
}

