/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.VariantType;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.DataSourceHandler;
import org.eclipse.scada.da.datasource.DataSourceHandlerImpl;
import org.eclipse.scada.da.datasource.DataSourceHandlerListener;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiDataSourceListener {
    private static final Logger logger = LoggerFactory.getLogger(MultiDataSourceListener.class);
    private final ObjectPoolTracker<DataSource> poolTracker;
    private final DataSourceHandlerListener listener;
    private final Map<String, DataSourceHandlerImpl> sources = new HashMap<String, DataSourceHandlerImpl>();
    private boolean disposed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiDataSourceListener(ObjectPoolTracker<DataSource> poolTracker) {
        MultiDataSourceListener multiDataSourceListener = this;
        synchronized (multiDataSourceListener) {
            this.poolTracker = poolTracker;
            this.listener = new DataSourceHandlerListener(){

                @Override
                public void handleChange() {
                    MultiDataSourceListener.this.triggerHandleChange();
                }
            };
        }
    }

    public synchronized Map<String, DataSourceHandler> getSourcesCopy() {
        return new HashMap<String, DataSourceHandler>(this.sources);
    }

    public synchronized void setDataSources(Map<String, String> parameters) throws InvalidSyntaxException {
        this.clearSources();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!key.startsWith("datasource.")) continue;
            String name = key.substring("datasource.".length());
            VariantType type = this.getType(parameters.get("datasourceType." + name));
            this.addDataSource(name, value, type);
        }
    }

    public VariantType getType(String type) {
        if (type == null || type.isEmpty()) {
            return null;
        }
        try {
            return VariantType.valueOf((String)type);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Datatype '%s' is unknown", type), e);
        }
    }

    protected abstract void handleChange(Map<String, DataSourceHandler> var1);

    public synchronized void addDataSource(String datasourceKey, String datasourceId, VariantType type) throws InvalidSyntaxException {
        logger.info("Adding data source: {} -> {} ({})", new Object[]{datasourceKey, datasourceId, type});
        DataSourceHandlerImpl dsHandler = new DataSourceHandlerImpl(this.poolTracker, datasourceId, this.listener, type);
        this.sources.put(datasourceKey, dsHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerHandleChange() {
        MultiDataSourceListener multiDataSourceListener = this;
        synchronized (multiDataSourceListener) {
            if (this.disposed) {
                return;
            }
        }
        this.handleChange(Collections.unmodifiableMap(this.sources));
    }

    public synchronized void clearSources() {
        for (DataSourceHandler dataSourceHandler : this.sources.values()) {
            dataSourceHandler.dispose();
        }
        this.sources.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Collection<DataSourceHandlerImpl> disposeSources;
        MultiDataSourceListener multiDataSourceListener = this;
        synchronized (multiDataSourceListener) {
            disposeSources = this.sources.values();
            this.disposed = true;
            this.sources.clear();
        }
        for (DataSourceHandler dataSourceHandler : disposeSources) {
            dataSourceHandler.dispose();
        }
    }
}

