/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.browser.common.query;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.scada.da.core.browser.Entry;
import org.eclipse.scada.da.core.server.browser.NoSuchFolderException;
import org.eclipse.scada.da.server.browser.common.FolderListener;
import org.eclipse.scada.da.server.browser.common.query.GroupProvider;
import org.eclipse.scada.da.server.browser.common.query.GroupSubFolder;
import org.eclipse.scada.da.server.browser.common.query.ItemDescriptor;
import org.eclipse.scada.da.server.browser.common.query.NameProvider;
import org.eclipse.scada.da.server.browser.common.query.StorageBasedFolder;

public class GroupFolder
implements StorageBasedFolder {
    private final Map<ItemDescriptor, GroupSubFolder> itemList = new HashMap<ItemDescriptor, GroupSubFolder>();
    private final GroupProvider groupProvider;
    private final NameProvider nameProvider;
    private final GroupSubFolder folder;

    public GroupFolder(GroupProvider groupProvider, NameProvider nameProvider) {
        this.groupProvider = groupProvider;
        this.nameProvider = nameProvider;
        this.folder = new GroupSubFolder(this.nameProvider);
    }

    @Override
    public synchronized Entry[] list(Stack<String> path) throws NoSuchFolderException {
        return this.folder.list(path);
    }

    @Override
    public synchronized void subscribe(Stack<String> path, FolderListener listener, Object tag) throws NoSuchFolderException {
        this.folder.subscribe(path, listener, tag);
    }

    @Override
    public synchronized void unsubscribe(Stack<String> path, Object tag) throws NoSuchFolderException {
        this.folder.unsubscribe(path, tag);
    }

    private static String[] reverse(String[] b) {
        int left = 0;
        int right = b.length - 1;
        while (left < right) {
            String temp = b[left];
            b[left] = b[right];
            b[right] = temp;
            ++left;
            --right;
        }
        return b;
    }

    @Override
    public synchronized void added(ItemDescriptor descriptor) {
        if (this.itemList.containsKey(descriptor)) {
            return;
        }
        String[] groupingArray = this.groupProvider.getGrouping(descriptor);
        if (groupingArray == null) {
            return;
        }
        Stack<String> pathStack = new Stack<String>();
        pathStack.addAll(Arrays.asList(GroupFolder.reverse(groupingArray)));
        GroupSubFolder subFolder = this.folder.add(pathStack, descriptor);
        if (subFolder != null) {
            this.itemList.put(descriptor, subFolder);
        }
    }

    @Override
    public synchronized void removed(ItemDescriptor descriptor) {
        GroupSubFolder folder = this.itemList.get(descriptor);
        if (folder == null) {
            return;
        }
        folder.remove(descriptor);
        this.itemList.remove(descriptor);
    }

    @Override
    public void added() {
        this.folder.added();
    }

    @Override
    public void removed() {
        this.folder.removed();
    }
}

