/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common;

import java.util.Map;
import org.eclipse.scada.core.InvalidOperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.core.DataItemInformation;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.server.common.AttributeManager;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.DataItemInput;
import org.eclipse.scada.da.server.common.WriteAttributesHelper;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public class DataItemInputCommon
extends DataItemInput {
    private volatile Variant value = Variant.NULL;
    private AttributeManager attributes = new AttributeManager(this);

    public DataItemInputCommon(DataItemInformation info) {
        super(info);
    }

    public DataItemInputCommon(String name) {
        super(name);
    }

    @Override
    public NotifyFuture<Variant> readValue() throws InvalidOperationException {
        return new InstantFuture((Object)this.value);
    }

    @Override
    public Map<String, Variant> getAttributes() {
        return this.attributes.get();
    }

    @Override
    public NotifyFuture<WriteAttributeResults> startSetAttributes(Map<String, Variant> attributes, OperationParameters operationParameters) {
        return new InstantFuture((Object)WriteAttributesHelper.errorUnhandled(null, attributes));
    }

    public synchronized void updateData(Variant value, Map<String, Variant> attributes, AttributeMode mode) {
        if (this.value == null || !this.value.equals((Object)value)) {
            this.value = value;
        } else {
            value = null;
        }
        this.attributes.update(value, attributes, mode);
    }

    @Override
    protected Map<String, Variant> getCacheAttributes() {
        return this.attributes.get();
    }

    @Override
    protected Variant getCacheValue() {
        return this.value;
    }
}

