/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.exporter;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.chain.WriteHandler;
import org.eclipse.scada.da.server.common.item.factory.FolderItemFactory;
import org.eclipse.scada.da.server.common.item.factory.ItemFactory;

public class TabularExporter {
    private final FolderItemFactory itemFactory;
    public Map<String, Row> rows = new HashMap<String, Row>();
    private final WriteHandlerFactory writeHandlerFactory;
    private final Set<String> commands;

    public TabularExporter(FolderItemFactory itemFactory, WriteHandlerFactory writeHandlerFactory, Set<String> commands) {
        this.itemFactory = itemFactory;
        this.writeHandlerFactory = writeHandlerFactory;
        this.commands = commands;
    }

    public void update(List<Entry> entries) {
        Row row;
        HashSet<String> keys = new HashSet<String>(this.rows.keySet());
        for (Entry entry : entries) {
            row = this.rows.get(entry.getId());
            if (row == null) {
                row = new Row(this.itemFactory, entry.getId(), this.writeHandlerFactory, this.commands);
                this.rows.put(entry.getId(), row);
            } else {
                keys.remove(entry.getId());
            }
            row.update(entry.getValues());
        }
        for (String key : keys) {
            row = this.rows.remove(key);
            if (row == null) continue;
            row.dispose();
        }
    }

    public void dispose() {
        for (Row row : this.rows.values()) {
            row.dispose();
        }
        this.rows.clear();
    }

    public void setGlobalError(Throwable e) {
        this.update(Collections.emptyList());
    }

    public static class Entry {
        private final String id;
        private final Map<String, Variant> values = new HashMap<String, Variant>();

        public Entry(String id) {
            this.id = id;
        }

        public void put(String key, Variant value) {
            this.values.put(key, value);
        }

        public void putAll(Map<String, Variant> values) {
            this.values.putAll(values);
        }

        public String getId() {
            return this.id;
        }

        public Map<String, Variant> getValues() {
            return this.values;
        }
    }

    private static class Row {
        private final ItemFactory itemFactory;
        private final WriteHandlerFactory writeHandlerFactory;
        private final Map<String, DataItemInputChained> items = new HashMap<String, DataItemInputChained>();

        public Row(FolderItemFactory itemFactory, String id, WriteHandlerFactory writeHandlerFactory, Set<String> commands) {
            this.itemFactory = itemFactory.createSubFolderFactory(id);
            this.writeHandlerFactory = writeHandlerFactory;
            for (String command : commands) {
                WriteHandler writeHandler = writeHandlerFactory.createCommandWriteHandler(id, command);
                if (writeHandler == null) continue;
                this.itemFactory.createOutput(command, null, writeHandler);
            }
        }

        public void dispose() {
            this.itemFactory.dispose();
            this.items.clear();
        }

        public void update(Map<String, Variant> values) {
            DataItemInputChained item;
            HashSet<String> currentItems = new HashSet<String>(this.items.keySet());
            for (Map.Entry<String, Variant> entry : values.entrySet()) {
                item = this.items.get(entry.getKey());
                if (item == null) {
                    item = this.createItem(entry.getKey(), entry.getKey());
                    this.items.put(entry.getKey(), item);
                } else {
                    currentItems.remove(entry.getKey());
                }
                item.updateData(entry.getValue(), null, null);
            }
            for (String itemId : currentItems) {
                item = this.items.remove(itemId);
                if (item == null) continue;
                this.itemFactory.disposeItem(item);
            }
        }

        public DataItemInputChained createItem(String id, String columnName) {
            WriteHandler writeHandler = this.writeHandlerFactory.createColumnWriteHandler(id, columnName);
            if (writeHandler != null) {
                return this.itemFactory.createInputOutput(columnName, null, writeHandler);
            }
            return this.itemFactory.createInput(columnName, null);
        }
    }

    public static interface WriteHandlerFactory {
        public WriteHandler createColumnWriteHandler(String var1, String var2);

        public WriteHandler createCommandWriteHandler(String var1, String var2);
    }
}

