/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.audit.log.ae;

import java.util.Date;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.data.Severity;
import org.eclipse.scada.ae.event.EventService;
import org.eclipse.scada.sec.AuthorizationReply;
import org.eclipse.scada.sec.AuthorizationRequest;
import org.eclipse.scada.sec.audit.AuditLogService;
import org.eclipse.scada.sec.authz.AuthorizationContext;
import org.eclipse.scada.utils.ExceptionHelper;
import org.eclipse.scada.utils.statuscodes.CodedExceptionBase;
import org.eclipse.scada.utils.statuscodes.StatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class AuditLogServiceImpl
implements AuditLogService {
    private static final Logger logger = LoggerFactory.getLogger(AuditLogServiceImpl.class);
    private static final String PROP_ENABLE_DEBUG = "org.eclipse.scada.sec.audit.log.ae.debug";
    private static final String PROP_LOG_ALL = "org.eclipse.scada.sec.audit.log.ae.logAll";
    private EventService eventService;

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    protected void log(Severity severity, AuthorizationContext context, String message, AuthorizationRequest request, AuthorizationReply reply, String value, Throwable error) {
        Event.EventBuilder evt = Event.create();
        Date now = new Date();
        evt.entryTimestamp(now);
        evt.sourceTimestamp(now);
        evt.attribute(Event.Fields.MESSAGE, (Object)message);
        if (request != null) {
            evt.attribute(Event.Fields.ACTOR_TYPE, (Object)request.getObjectType());
            evt.attribute(Event.Fields.ACTOR_NAME, (Object)request.getObjectId());
            evt.attribute(Event.Fields.ITEM, (Object)request.getAction());
            evt.attribute(Event.Fields.EVENT_TYPE, (Object)"SEC");
            evt.attribute(Event.Fields.MONITOR_TYPE, (Object)"AUDIT");
        }
        if (value != null) {
            evt.attribute(Event.Fields.VALUE, (Object)value);
        }
        if (error != null) {
            evt.attribute("errorInformation", (Object)ExceptionHelper.formatted((Throwable)error));
        }
        if (context != null) {
            evt.attribute("signature", context.getContext().get("signature"));
            evt.attribute("failedSignature", context.getContext().get("failedSignature"));
        }
        Event event = evt.build();
        logger.debug("Publishing event: {}", (Object)event);
        this.eventService.publishEvent(event);
    }

    protected void log(Severity severity, String message, Throwable error) {
        this.log(severity, null, message, null, null, this.getStatusCode(error), error);
    }

    public void info(String message, Object ... arguments) {
        this.log(Severity.INFORMATION, MessageFormatter.arrayFormat((String)message, (Object[])arguments).getMessage(), null);
    }

    public void debug(String message, Object ... arguments) {
        if (Boolean.getBoolean(PROP_ENABLE_DEBUG)) {
            this.log(Severity.INFORMATION, MessageFormatter.arrayFormat((String)message, (Object[])arguments).getMessage(), null);
        }
    }

    public void info(String message, Throwable e, Object ... arguments) {
        this.log(Severity.INFORMATION, MessageFormatter.arrayFormat((String)message, (Object[])arguments).getMessage(), e);
    }

    public void debug(String message, Throwable e, Object ... arguments) {
        if (Boolean.getBoolean(PROP_ENABLE_DEBUG)) {
            this.log(Severity.INFORMATION, MessageFormatter.arrayFormat((String)message, (Object[])arguments).getMessage(), e);
        }
    }

    public void authorizationRequested(AuthorizationRequest request) {
        if (Boolean.getBoolean(PROP_LOG_ALL)) {
            this.log(Severity.INFORMATION, "Authorization requested", null);
        }
    }

    public void authorizationFailed(AuthorizationContext context, AuthorizationRequest request, Throwable error) {
        this.log(Severity.ERROR, context, "Authorization failed", request, null, this.getStatusCode(error), error);
    }

    protected String getStatusCode(Throwable error) {
        StatusCode statusCode;
        if (error == null) {
            return null;
        }
        Throwable root = ExceptionHelper.getRootCause((Throwable)error);
        if (root instanceof CodedExceptionBase && (statusCode = ((CodedExceptionBase)root).getStatus()) != null) {
            return statusCode.toString();
        }
        return null;
    }

    public void authorizationDone(AuthorizationContext context, AuthorizationRequest request, AuthorizationReply reply) {
        if (reply.isGranted() && Boolean.getBoolean(PROP_LOG_ALL)) {
            this.log(Severity.INFORMATION, context, "Authorization granted", request, reply, null, null);
        } else if (!reply.isGranted()) {
            this.log(Severity.WARNING, context, "Authorization rejected", request, reply, null, null);
        }
    }
}

