/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.net.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.core.net.MessageHelper;
import org.eclipse.scada.da.core.browser.DataItemEntry;
import org.eclipse.scada.da.core.browser.Entry;
import org.eclipse.scada.da.core.browser.FolderEntry;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.da.net.handler.DataItemEntryCommon;
import org.eclipse.scada.da.net.handler.EntryCommon;
import org.eclipse.scada.da.net.handler.FolderEntryCommon;
import org.eclipse.scada.da.net.handler.Messages;
import org.eclipse.scada.net.base.data.IntegerValue;
import org.eclipse.scada.net.base.data.ListValue;
import org.eclipse.scada.net.base.data.LongValue;
import org.eclipse.scada.net.base.data.MapValue;
import org.eclipse.scada.net.base.data.Message;
import org.eclipse.scada.net.base.data.StringValue;
import org.eclipse.scada.net.base.data.Value;
import org.eclipse.scada.net.base.data.ValueTools;
import org.eclipse.scada.net.base.data.VoidValue;
import org.eclipse.scada.utils.lang.Holder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListBrowser {
    private static final Logger logger = LoggerFactory.getLogger(ListBrowser.class);

    public static Message createRequest(String[] path) {
        Message message = new Message(66048);
        ListValue value = new ListValue();
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String tok = stringArray[n2];
            value.add((Value)new StringValue(tok));
            ++n2;
        }
        message.getValues().put("path", (Value)value);
        return message;
    }

    public static String[] parseRequest(Message message) {
        ArrayList<String> list = new ArrayList<String>();
        List listValue = null;
        if (message.getValues().containsKey("path") && message.getValues().get("path") instanceof ListValue) {
            listValue = ((ListValue)message.getValues().get("path")).getValues();
        }
        if (listValue == null) {
            return new String[0];
        }
        for (Value value : listValue) {
            list.add(value.toString());
        }
        return list.toArray(new String[0]);
    }

    private static void createEntries(Message message, String field, Iterable<Entry> entries) {
        ListValue list = new ListValue();
        for (Entry entry : entries) {
            MapValue mapValue = new MapValue();
            mapValue.put("name", (Value)new StringValue(entry.getName()));
            mapValue.put("attributes", (Value)MessageHelper.attributesToMap((Map)entry.getAttributes()));
            if (entry instanceof FolderEntry) {
                mapValue.put("type", (Value)new StringValue("folder"));
            } else if (entry instanceof DataItemEntry) {
                mapValue.put("type", (Value)new StringValue("item"));
                DataItemEntry dataItemEntry = (DataItemEntry)entry;
                mapValue.put("item-id", (Value)new StringValue(dataItemEntry.getId()));
                mapValue.put("io-direction", (Value)IntegerValue.valueOf((int)Messages.encodeIO(dataItemEntry.getIODirections())));
            } else {
                mapValue.put("type", (Value)new StringValue("unknown"));
            }
            list.add((Value)mapValue);
        }
        message.getValues().put(field, (Value)list);
    }

    public static Message createResponse(long id, Entry[] entries) {
        Message message = new Message(66049);
        ListBrowser.createEntries(message, "entries", Arrays.asList(entries));
        message.getValues().put("id", (Value)new LongValue(id));
        return message;
    }

    public static Message createResponse(long id, String failure) {
        Message message = new Message(66049);
        message.getValues().put("error-info", (Value)new StringValue(failure));
        message.getValues().put("id", (Value)new LongValue(id));
        return message;
    }

    private static void parseEntries(Message message, String field, List<Entry> list) {
        list.clear();
        if (!message.getValues().containsKey(field)) {
            logger.warn("Required value '{}' missing", (Object)field);
            return;
        }
        if (!(message.getValues().get(field) instanceof ListValue)) {
            logger.warn("'{}' must be of type 'list'", (Object)field);
            return;
        }
        ListValue entries = (ListValue)message.getValues().get(field);
        for (Value value : entries.getValues()) {
            if (!(value instanceof MapValue)) {
                logger.warn("list value is not of type 'map'. Skipping!");
                continue;
            }
            MapValue mapValue = (MapValue)value;
            EntryCommon entry = null;
            if (!mapValue.containsKey("type")) {
                logger.warn("map misses required value 'type'");
                continue;
            }
            if (!mapValue.containsKey("name")) {
                logger.warn("map misses required value 'name'");
                continue;
            }
            if (!mapValue.containsKey("attributes")) {
                logger.warn("map misses required value 'attributes'");
                continue;
            }
            if (!(mapValue.get("attributes") instanceof MapValue)) {
                logger.warn("map entry 'attributes' is not of type MapValue");
                continue;
            }
            String type = mapValue.get("type").toString();
            Map attributes = MessageHelper.mapToAttributes((MapValue)((MapValue)mapValue.get("attributes")));
            logger.debug("entry type: '{}'");
            if (type.equals("folder")) {
                entry = new FolderEntryCommon(mapValue.get("name").toString(), attributes);
            } else if (type.equals("item")) {
                if (!mapValue.containsKey("item-id")) {
                    logger.warn("map entry is an item but misses 'item-id' ");
                    continue;
                }
                if (!mapValue.containsKey("io-direction")) {
                    logger.warn("map entry is an item but misses 'io-direction' ");
                    continue;
                }
                String id = mapValue.get("item-id").toString();
                Set<IODirection> io = Messages.decodeIO(ValueTools.toInteger((Value)mapValue.get("io-direction"), (int)0));
                entry = new DataItemEntryCommon(mapValue.get("name").toString(), io, attributes, id);
            }
            if (entry == null) continue;
            list.add(entry);
        }
    }

    public static Entry[] parseResponse(Message message) {
        ArrayList<Entry> list = new ArrayList<Entry>();
        ListBrowser.parseEntries(message, "entries", list);
        return list.toArray(new Entry[list.size()]);
    }

    public static void parseEvent(Message message, List<String> path, List<Entry> added, List<String> removed, Holder<Boolean> full) {
        path.clear();
        added.clear();
        removed.clear();
        if (message.getValues().containsKey("path") && message.getValues().get("path") instanceof ListValue) {
            path.addAll(ValueTools.fromStringList((ListValue)((ListValue)message.getValues().get("path"))));
        }
        ListBrowser.parseEntries(message, "added", added);
        full.value = message.getValues().containsKey("full");
        if (message.getValues().containsKey("removed") && message.getValues().get("removed") instanceof ListValue) {
            ListValue listValue = (ListValue)message.getValues().get("removed");
            for (Value value : listValue.getValues()) {
                removed.add(value.toString());
            }
        }
    }

    public static Message createEvent(String[] path, Collection<Entry> added, Collection<String> removed, boolean full) {
        Message message = new Message(66064);
        if (full) {
            message.getValues().put("full", (Value)VoidValue.INSTANCE);
        }
        message.getValues().put("path", (Value)ValueTools.toStringList(Arrays.asList(path)));
        message.getValues().put("removed", (Value)ValueTools.toStringList(removed));
        ListBrowser.createEntries(message, "added", added);
        return message;
    }

    private static Message createRegMessage(int commandCode, String[] path) {
        Message message = new Message(commandCode);
        message.getValues().put("path", (Value)ValueTools.toStringList(Arrays.asList(path)));
        return message;
    }

    public static Message createSubscribe(String[] path) {
        return ListBrowser.createRegMessage(66065, path);
    }

    public static Message createUnsubscribe(String[] path) {
        return ListBrowser.createRegMessage(66066, path);
    }

    private static String[] parseRegMessage(Message message) {
        if (!message.getValues().containsKey("path")) {
            return new String[0];
        }
        if (!(message.getValues().get("path") instanceof ListValue)) {
            return new String[0];
        }
        return ValueTools.fromStringList((ListValue)((ListValue)message.getValues().get("path"))).toArray(new String[0]);
    }

    public static String[] parseSubscribeMessage(Message message) {
        return ListBrowser.parseRegMessage(message);
    }

    public static String[] parseUnsubscribeMessage(Message message) {
        return ListBrowser.parseRegMessage(message);
    }
}

