/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.server.common;

import java.util.Map;
import java.util.concurrent.Future;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.core.server.common.AuthorizationProvider;
import org.eclipse.scada.core.server.common.session.AbstractSessionImpl;
import org.eclipse.scada.sec.AuthorizationReply;
import org.eclipse.scada.sec.AuthorizationRequest;
import org.eclipse.scada.sec.AuthorizationResult;
import org.eclipse.scada.sec.PermissionDeniedException;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.concurrent.AbstractFuture;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public abstract class AuthorizedOperation<T, SI extends AbstractSessionImpl>
extends AbstractFuture<T> {
    private final String objectType;
    private final String objectId;
    private final String action;
    private final Map<String, Object> context;
    private final AuthorizationProvider<SI> authorizationProvider;
    private final CallbackHandler handler;
    private final AuthorizationResult defaultResult;
    private final org.eclipse.scada.core.data.OperationParameters operationParameters;

    public AuthorizedOperation(AuthorizationProvider<SI> authorizationProvider, SI session, String objectType, String objectId, String action, Map<String, Object> context, org.eclipse.scada.core.data.OperationParameters operationParameters, CallbackHandler handler, AuthorizationResult defaultResult) {
        this.authorizationProvider = authorizationProvider;
        this.objectType = objectType;
        this.objectId = objectId;
        this.action = action;
        this.context = context;
        this.handler = handler;
        this.defaultResult = defaultResult;
        this.operationParameters = operationParameters;
        NotifyFuture<UserInformation> future = this.authorizationProvider.impersonate(session, operationParameters == null ? null : operationParameters.getUserInformation().getName(), handler);
        future.addListener((FutureListener)new FutureListener<UserInformation>(){

            public void complete(Future<UserInformation> future) {
                AuthorizedOperation.this.handleCompleteImpersonate(future);
            }
        });
    }

    protected void handleCompleteImpersonate(Future<UserInformation> future) {
        try {
            UserInformation userInformation = future.get();
            NotifyFuture<AuthorizationReply> f = this.authorizationProvider.authorize(this.makeRequest(userInformation), this.handler, this.defaultResult);
            f.addListener((FutureListener)new FutureListener<AuthorizationReply>(){

                public void complete(Future<AuthorizationReply> future) {
                    AuthorizedOperation.this.handleCompleteAuthorize(future);
                }
            });
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    protected void handleCompleteAuthorize(Future<AuthorizationReply> future) {
        try {
            AuthorizationReply result = future.get();
            PermissionDeniedException ex = result.getResult().asException();
            if (ex != null) {
                this.setError((Throwable)ex);
                return;
            }
            NotifyFuture<T> f = this.granted(this.makeParameters(result));
            f.addListener(new FutureListener<T>(){

                public void complete(Future<T> future) {
                    try {
                        AuthorizedOperation.this.setResult(future.get());
                    }
                    catch (Exception e) {
                        AuthorizedOperation.this.setError(e);
                    }
                }
            });
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    private OperationParameters makeParameters(AuthorizationReply result) {
        return new OperationParameters(result.getUserInformation(), this.operationParameters == null ? null : this.operationParameters.getProperties(), this.handler);
    }

    private AuthorizationRequest makeRequest(UserInformation effective) {
        return new AuthorizationRequest(this.objectType, this.objectId, this.action, effective, this.context);
    }

    protected abstract NotifyFuture<T> granted(OperationParameters var1);
}

