/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.monitor.script;

import com.google.common.collect.Interner;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ae.monitor.MonitorService;
import org.eclipse.scada.ae.monitor.script.ScriptMonitor;
import org.eclipse.scada.ca.ConfigurationAdministrator;
import org.eclipse.scada.ca.common.factory.AbstractServiceConfigurationFactory;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ScriptMonitorFactory
extends AbstractServiceConfigurationFactory<ScriptMonitor> {
    public static final String FACTORY_ID = "org.eclipse.scada.ae.monitor.script";
    private final Interner<String> stringInterner;
    private final Executor executor;
    private final EventProcessor eventProcessor;
    private final ObjectPoolTracker<DataSource> dataSourcePoolTracker;
    private final ObjectPoolTracker<MasterItem> masterItemPoolTracker;
    private final ServiceTracker<ConfigurationAdministrator, ConfigurationAdministrator> caTracker;
    private final ObjectPoolImpl<MonitorService> monitorServicePool;

    public ScriptMonitorFactory(BundleContext context, Executor executor, Interner<String> stringInterner, EventProcessor eventProcessor, ObjectPoolTracker<DataSource> dataSourcePoolTracker, ObjectPoolTracker<MasterItem> masterItemPoolTracker, ServiceTracker<ConfigurationAdministrator, ConfigurationAdministrator> caTracker, ObjectPoolImpl<MonitorService> monitorServicePool) {
        super(context);
        this.executor = executor;
        this.stringInterner = stringInterner;
        this.eventProcessor = eventProcessor;
        this.dataSourcePoolTracker = dataSourcePoolTracker;
        this.masterItemPoolTracker = masterItemPoolTracker;
        this.caTracker = caTracker;
        this.monitorServicePool = monitorServicePool;
    }

    protected AbstractServiceConfigurationFactory.Entry<ScriptMonitor> createService(UserInformation userInformation, String configurationId, BundleContext context, Map<String, String> parameters) throws Exception {
        ScriptMonitor service = new ScriptMonitor(configurationId, FACTORY_ID, this.executor, context, this.stringInterner, this.eventProcessor, this.dataSourcePoolTracker, this.masterItemPoolTracker, this.caTracker);
        service.update(userInformation, parameters);
        this.monitorServicePool.addService(configurationId, (Object)service, new Hashtable(0));
        return new AbstractServiceConfigurationFactory.Entry(configurationId, (Object)service);
    }

    protected void disposeService(UserInformation userInformation, String configurationId, ScriptMonitor service) {
        this.monitorServicePool.removeService(configurationId, (Object)service);
        service.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<ScriptMonitor> updateService(UserInformation userInformation, String configurationId, AbstractServiceConfigurationFactory.Entry<ScriptMonitor> entry, Map<String, String> parameters) throws Exception {
        ((ScriptMonitor)((Object)entry.getService())).update(userInformation, parameters);
        return null;
    }
}

