/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.eclipse.scada.base.json.VariantJsonDeserializer;
import org.eclipse.scada.base.json.VariantJsonSerializer;
import org.eclipse.scada.da.client.DataItemValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"application/json", "text/plain"})
public class DataItemValueProvider
implements MessageBodyWriter<DataItemValue> {
    private static final Logger logger = LoggerFactory.getLogger(DataItemValueProvider.class);
    private static final MediaType[] SUPPORTED_TYPES_ARRAY = new MediaType[]{MediaType.APPLICATION_JSON_TYPE};
    private final Gson gson;

    public DataItemValueProvider() {
        logger.debug("Created instance");
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(org.eclipse.scada.core.Variant.class, (Object)new VariantJsonSerializer());
        builder.registerTypeAdapter(org.eclipse.scada.core.Variant.class, (Object)new VariantJsonDeserializer());
        this.gson = builder.create();
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        logger.trace("isWritable");
        return DataItemValue.class.isAssignableFrom(type);
    }

    public long getSize(DataItemValue t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(DataItemValue t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        logger.trace("writeTo");
        if (MediaType.APPLICATION_JSON_TYPE.isCompatible(mediaType)) {
            PrintWriter writer = new PrintWriter(entityStream);
            writer.print(this.gson.toJson((Object)t));
            writer.flush();
        } else if (MediaType.TEXT_PLAIN_TYPE.isCompatible(mediaType)) {
            PrintWriter writer = new PrintWriter(entityStream);
            writer.print(t.toString());
            writer.flush();
        } else {
            throw new WebApplicationException(Response.notAcceptable((List)Variant.mediaTypes((MediaType[])SUPPORTED_TYPES_ARRAY).build()).build());
        }
    }
}

