/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.exec.configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VariantTypeType implements Enumerator
{
    BOOLEAN(0, "BOOLEAN", "BOOLEAN"),
    INTEGER(1, "INTEGER", "INTEGER"),
    LONG(2, "LONG", "LONG"),
    DOUBLE(3, "DOUBLE", "DOUBLE"),
    STRING(4, "STRING", "STRING");

    public static final String copyright = "Copyright (c) 2013 Jens Reimann and others.\nAll rights reserved. This program and the accompanying materials\nare made available under the terms of the Eclipse Public License v1.0\nwhich accompanies this distribution, and is available at\nhttp://www.eclipse.org/legal/epl-v10.html\n\nContributors:\n    Jens Reimann - initial API and implementation";
    public static final int BOOLEAN_VALUE = 0;
    public static final int INTEGER_VALUE = 1;
    public static final int LONG_VALUE = 2;
    public static final int DOUBLE_VALUE = 3;
    public static final int STRING_VALUE = 4;
    private static final VariantTypeType[] VALUES_ARRAY;
    public static final List<VariantTypeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VariantTypeType[]{BOOLEAN, INTEGER, LONG, DOUBLE, STRING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VariantTypeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VariantTypeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VariantTypeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VariantTypeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VariantTypeType get(int value) {
        switch (value) {
            case 0: {
                return BOOLEAN;
            }
            case 1: {
                return INTEGER;
            }
            case 2: {
                return LONG;
            }
            case 3: {
                return DOUBLE;
            }
            case 4: {
                return STRING;
            }
        }
        return null;
    }

    private VariantTypeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

