/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exec.extractor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.item.factory.FolderItemFactory;
import org.eclipse.scada.da.server.exec.Hive;
import org.eclipse.scada.da.server.exec.command.ExecutionResult;
import org.eclipse.scada.da.server.exec.extractor.AbstractBaseExtractor;

public abstract class AbstractArrayExtractor
extends AbstractBaseExtractor {
    private final List<FieldMapping> fields;
    private final Map<Integer, DataItemInputChained> inputs = new HashMap<Integer, DataItemInputChained>();

    public AbstractArrayExtractor(String id, List<FieldMapping> fields) {
        super(id);
        this.fields = fields;
    }

    @Override
    protected void doProcess(ExecutionResult result) throws Exception {
        String[] fields = this.getFields(result);
        int i = 0;
        while (i < fields.length) {
            this.updateData(fields[i], i);
            ++i;
        }
    }

    protected abstract String[] getFields(ExecutionResult var1);

    @Override
    public void register(Hive hive, FolderItemFactory folderItemFactory) {
        super.register(hive, folderItemFactory);
        int i = 0;
        for (FieldMapping group : this.fields) {
            String valueName = group.getName();
            if (valueName != null && valueName.length() > 0) {
                this.inputs.put(i, this.createInput(valueName));
            }
            ++i;
        }
    }

    protected void updateData(String value, int group) {
        Variant variant;
        FieldMapping mapping;
        try {
            mapping = this.fields.get(group);
        }
        catch (Throwable throwable) {
            return;
        }
        if (mapping == null) {
            return;
        }
        DataItemInputChained item = this.getItemForGroup(group);
        if (item == null) {
            return;
        }
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        this.fillNoError(attributes);
        attributes.put("extractor.conversion.error", null);
        attributes.put("extractor.conversion.error.message", null);
        try {
            switch (mapping.getType()) {
                case BOOLEAN: {
                    variant = Variant.valueOf((boolean)Boolean.parseBoolean(value));
                    break;
                }
                case DOUBLE: {
                    variant = Variant.valueOf((double)Double.parseDouble(value));
                    break;
                }
                case INTEGER: {
                    variant = Variant.valueOf((int)Integer.parseInt(value));
                    break;
                }
                case LONG: {
                    variant = Variant.valueOf((long)Long.parseLong(value));
                    break;
                }
                default: {
                    variant = Variant.valueOf((Object)value);
                    break;
                }
            }
        }
        catch (Throwable e) {
            attributes.put("extractor.conversion.error", Variant.TRUE);
            attributes.put("extractor.conversion.error.message", Variant.valueOf((Object)e.getMessage()));
            variant = Variant.NULL;
        }
        item.updateData(variant, attributes, AttributeMode.UPDATE);
    }

    protected DataItemInputChained getItemForGroup(int group) {
        return this.inputs.get(group);
    }

    public static class FieldMapping {
        private String name;
        private FieldType type;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public FieldType getType() {
            return this.type;
        }

        public void setType(FieldType type) {
            this.type = type;
        }
    }

    public static enum FieldType {
        STRING,
        BOOLEAN,
        INTEGER,
        LONG,
        DOUBLE;

    }
}

