/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.net;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.scada.core.NotConvertableException;
import org.eclipse.scada.core.NullValueException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.OperationParameters;
import org.eclipse.scada.core.data.UserInformation;
import org.eclipse.scada.net.base.data.BooleanValue;
import org.eclipse.scada.net.base.data.DoubleValue;
import org.eclipse.scada.net.base.data.IntegerValue;
import org.eclipse.scada.net.base.data.ListValue;
import org.eclipse.scada.net.base.data.LongValue;
import org.eclipse.scada.net.base.data.MapValue;
import org.eclipse.scada.net.base.data.Message;
import org.eclipse.scada.net.base.data.StringValue;
import org.eclipse.scada.net.base.data.Value;
import org.eclipse.scada.net.base.data.VoidValue;

public class MessageHelper {
    public static final int CC_CREATE_SESSION = 65537;
    public static final int CC_CLOSE_SESSION = 65538;
    public static final int CC_PRIV_CHANGE = 65539;
    public static final int CC_START_SESSION = 65540;
    public static final String FIELD_SESSION_PROPERTIES = "properties";
    public static final String FIELD_TRANSPORT_PROPERTIES = "transport.properties";
    public static final String FIELD_PRIVS = "privileges";
    public static final Object PROP_USING_SESSION_START = "using.sessionStart";
    public static final String FIELD_USER = "user";
    public static final String FIELD_OPERATION_PARAMETERS = "operation-parameters";

    public static Map<String, Variant> mapToAttributes(MapValue mapValue) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(mapValue.getValues().size());
        for (Map.Entry entry : mapValue.getValues().entrySet()) {
            Variant value = null;
            Value entryValue = (Value)entry.getValue();
            value = MessageHelper.valueToVariant(entryValue, null);
            if (value == null) continue;
            attributes.put((String)entry.getKey(), value);
        }
        return attributes;
    }

    public static MapValue attributesToMap(Map<String, Variant> attributes) {
        MapValue mapValue = new MapValue(attributes.size());
        for (Map.Entry<String, Variant> entry : attributes.entrySet()) {
            Value value = MessageHelper.variantToValue(entry.getValue());
            if (value == null) continue;
            mapValue.put(entry.getKey(), value);
        }
        return mapValue;
    }

    public static Variant valueToVariant(Value value, Variant defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof StringValue) {
            return Variant.valueOf((Object)((StringValue)value).getValue());
        }
        if (value instanceof BooleanValue) {
            return Variant.valueOf((boolean)((BooleanValue)value).getValue());
        }
        if (value instanceof DoubleValue) {
            return Variant.valueOf((double)((DoubleValue)value).getValue());
        }
        if (value instanceof LongValue) {
            return Variant.valueOf((long)((LongValue)value).getValue());
        }
        if (value instanceof IntegerValue) {
            return Variant.valueOf((int)((IntegerValue)value).getValue());
        }
        if (value instanceof VoidValue) {
            return Variant.NULL;
        }
        return defaultValue;
    }

    public static Value variantToValue(Variant value) {
        if (value == null) {
            return null;
        }
        try {
            if (value.isDouble()) {
                return new DoubleValue(value.asDouble());
            }
            if (value.isInteger()) {
                return new IntegerValue(value.asInteger());
            }
            if (value.isLong()) {
                return new LongValue(value.asLong());
            }
            if (value.isBoolean()) {
                return BooleanValue.valueOf((boolean)value.asBoolean());
            }
            if (value.isString()) {
                return new StringValue(value.asString());
            }
            if (value.isNull()) {
                return VoidValue.INSTANCE;
            }
        }
        catch (NullValueException nullValueException) {
            return VoidValue.INSTANCE;
        }
        catch (NotConvertableException notConvertableException) {}
        return null;
    }

    public static Message createSession(Properties props) {
        Message msg = new Message(65537);
        msg.getValues().put(FIELD_SESSION_PROPERTIES, (Value)MessageHelper.toValue(props));
        return msg;
    }

    public static Message closeSession() {
        return new Message(65538);
    }

    public static void getProperties(Properties properties, Value value) {
        if (value instanceof MapValue) {
            MapValue mapValue = (MapValue)value;
            for (Map.Entry entry : mapValue.getValues().entrySet()) {
                properties.put(entry.getKey(), ((Value)entry.getValue()).toString());
            }
        }
    }

    public static Message createSessionACK(Message inputMessage, Map<String, String> sessionProperties, Map<String, String> transportProperties) {
        Message message = new Message(3, inputMessage.getSequence());
        if (sessionProperties != null) {
            message.getValues().put(FIELD_SESSION_PROPERTIES, (Value)MessageHelper.toValue(sessionProperties));
        }
        if (transportProperties != null) {
            message.getValues().put(FIELD_TRANSPORT_PROPERTIES, (Value)MessageHelper.toValue(transportProperties));
        }
        return message;
    }

    private static MapValue toValue(Map<? extends Object, ? extends Object> sessionProperties) {
        MapValue value = new MapValue();
        if (sessionProperties != null) {
            for (Map.Entry<? extends Object, ? extends Object> entry : sessionProperties.entrySet()) {
                value.put(entry.getKey().toString(), (Value)new StringValue(entry.getValue().toString()));
            }
        }
        return value;
    }

    public static Message createPrivilegeChange(Set<String> privileges) {
        Message message = new Message(65539);
        ListValue value = new ListValue(privileges.size());
        for (String string : privileges) {
            value.add((Value)new StringValue(string));
        }
        message.getValues().put(FIELD_PRIVS, (Value)value);
        return message;
    }

    public static Set<String> getPrivileges(Message message) {
        HashSet<String> result = new HashSet<String>();
        Value value = message.getValues().get(FIELD_PRIVS);
        if (!(value instanceof ListValue)) {
            return result;
        }
        for (Value valueEntry : ((ListValue)value).getValues()) {
            if (valueEntry == null) continue;
            result.add(valueEntry.toString());
        }
        return result;
    }

    public static OperationParameters convertOperationParameters(Value value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof MapValue)) {
            return null;
        }
        MapValue mapValue = (MapValue)value;
        String user = mapValue.get(FIELD_USER) != null ? mapValue.get(FIELD_USER).toString() : null;
        return new OperationParameters(new UserInformation(user), null);
    }

    public static void encodeOperationParameters(OperationParameters operationParameters, Message message) {
        if (operationParameters != null) {
            MapValue parameters = new MapValue(2);
            message.getValues().put(FIELD_OPERATION_PARAMETERS, (Value)parameters);
            if (operationParameters.getUserInformation() != null && operationParameters.getUserInformation().getName() != null) {
                parameters.put(FIELD_USER, (Value)new StringValue(operationParameters.getUserInformation().getName()));
            }
        }
    }
}

