/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.sum;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.DataSourceHandler;
import org.eclipse.scada.da.datasource.MultiDataSourceListener;
import org.eclipse.scada.da.datasource.base.AbstractDataSource;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SumDataSource
extends AbstractDataSource {
    private static final Logger logger = LoggerFactory.getLogger(SumDataSource.class);
    private final Executor executor;
    private Set<String> groups;
    private Entry[] entries;
    private Entry errorEntry;
    private final MultiDataSourceListener itemListener;
    private final MultiDataSourceListener subItemListener;

    public SumDataSource(ObjectPoolTracker<DataSource> poolTracker, Executor executor) {
        this.executor = executor;
        this.itemListener = new MultiDataSourceListener(poolTracker){

            protected void handleChange(Map<String, DataSourceHandler> sources) {
                SumDataSource.this.handleChange();
            }
        };
        this.subItemListener = new MultiDataSourceListener(poolTracker){

            protected void handleChange(Map<String, DataSourceHandler> sources) {
                SumDataSource.this.handleChange();
            }
        };
    }

    public void dispose() {
        this.itemListener.dispose();
        this.subItemListener.dispose();
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    public NotifyFuture<WriteAttributeResults> startWriteAttributes(Map<String, Variant> attributes, OperationParameters operationParameters) {
        return new InstantErrorFuture((Throwable)new OperationException("Not supported"));
    }

    public NotifyFuture<WriteResult> startWriteValue(Variant value, OperationParameters operationParameters) {
        return new InstantErrorFuture((Throwable)new OperationException("Not supported"));
    }

    public synchronized void update(Map<String, String> parameters) throws Exception {
        String groupsString = parameters.get("groups");
        if (groupsString == null) {
            groupsString = "";
        }
        this.itemListener.clearSources();
        this.subItemListener.clearSources();
        this.groups = new HashSet<String>(Arrays.asList(groupsString.split(", ?")));
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String id;
            String key = entry.getKey();
            if (key.startsWith("datasource.")) {
                id = entry.getValue();
                logger.info("Adding datasource: {} -> {}", (Object)key, (Object)id);
                this.itemListener.addDataSource(key, id, null);
                continue;
            }
            if (!key.startsWith("subDatasource.")) continue;
            id = entry.getValue();
            logger.info("Adding sub datasource: {} -> {}", (Object)key, (Object)id);
            this.subItemListener.addDataSource(key, id, null);
        }
        LinkedList<Entry> localEntries = new LinkedList<Entry>();
        for (String group : this.groups) {
            localEntries.add(new Entry(group));
        }
        this.entries = localEntries.toArray(new Entry[localEntries.size()]);
        this.errorEntry = null;
        Entry[] entryArray = this.entries;
        int n = this.entries.length;
        int n2 = 0;
        while (n2 < n) {
            Entry entry = entryArray[n2];
            if ("error".equals(entry.name)) {
                this.errorEntry = entry;
            }
            ++n2;
        }
        this.handleChange();
    }

    protected synchronized void handleChange() {
        this.updateData(this.aggregate(this.itemListener.getSourcesCopy(), this.subItemListener.getSourcesCopy()));
    }

    private boolean isDebug() {
        return Boolean.getBoolean("org.eclipse.scada.da.datasource.sum.debug");
    }

    protected synchronized DataItemValue aggregate(Map<String, DataSourceHandler> values, Map<String, DataSourceHandler> subValues) {
        Entry group;
        DataItemValue.Builder builder = new DataItemValue.Builder();
        builder.setSubscriptionState(SubscriptionState.CONNECTED);
        int count = values.size();
        boolean debug = this.isDebug();
        Entry[] entryArray = this.entries;
        int n = this.entries.length;
        int n2 = 0;
        while (n2 < n) {
            group = entryArray[n2];
            group.active = false;
            ++n2;
        }
        this.aggregateValues(values, builder, debug, false);
        count += this.aggregateValues(subValues, builder, debug, true);
        entryArray = this.entries;
        n = this.entries.length;
        n2 = 0;
        while (n2 < n) {
            group = entryArray[n2];
            builder.setAttribute(group.name, Variant.valueOf((boolean)group.active));
            ++n2;
        }
        builder.setValue(Variant.valueOf((int)count));
        return builder.build();
    }

    private int aggregateValues(Map<String, DataSourceHandler> values, DataItemValue.Builder builder, boolean debug, boolean doCount) {
        int result = 0;
        for (Map.Entry<String, DataSourceHandler> entry : values.entrySet()) {
            DataItemValue value = entry.getValue().getValue();
            if (!(this.errorEntry == null || value != null && value.isConnected())) {
                this.errorEntry.active = true;
                continue;
            }
            if (doCount) {
                result += value.getValue().asInteger(Integer.valueOf(0)).intValue();
            }
            Entry[] entryArray = this.entries;
            int n = this.entries.length;
            int n2 = 0;
            while (n2 < n) {
                Entry group = entryArray[n2];
                if (value.isAttribute(group.name, false)) {
                    if (debug) {
                        builder.setAttribute(String.format("sum.%s.%s", group, entry.getKey()), Variant.TRUE);
                    }
                    group.active = true;
                }
                ++n2;
            }
        }
        return result;
    }

    private static class Entry {
        private final String name;
        private boolean active;

        public Entry(String name) {
            this.name = name;
        }
    }
}

