/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.memory;

import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.memory.AbstractAttribute;
import org.eclipse.scada.da.server.common.memory.Attribute;
import org.eclipse.scada.da.server.common.memory.MemoryRequestBlock;

public class BitAttribute
extends AbstractAttribute
implements Attribute {
    private final int index;
    private final int subIndex;
    private Boolean lastValue;
    private Variant lastTimestamp;
    private final boolean enableTimestamp;

    public BitAttribute(String name, int index, int subIndex, boolean enableTimestamp) {
        super(name);
        this.index = index;
        this.subIndex = subIndex;
        this.enableTimestamp = enableTimestamp;
    }

    @Override
    public void handleData(IoBuffer data, Map<String, Variant> attributes, Variant timestamp) {
        byte b = data.get(this.toAddress(this.index));
        boolean flag = (b & 1 << this.subIndex) != 0;
        attributes.put(this.name, Variant.valueOf((boolean)flag));
        if (!Boolean.valueOf(flag).equals(this.lastValue)) {
            this.lastValue = flag;
            this.lastTimestamp = timestamp;
        }
        if (this.enableTimestamp) {
            attributes.put(String.valueOf(this.name) + ".timestamp", this.lastTimestamp);
        }
    }

    @Override
    public void handleError(Map<String, Variant> attributes) {
        this.lastValue = null;
        this.lastTimestamp = null;
    }

    @Override
    public void handleWrite(Variant value) {
        MemoryRequestBlock block = this.block;
        if (block == null) {
            throw new IllegalStateException("Device is not connected");
        }
        block.writeBit(this.toAddress(this.index), this.subIndex, value.asBoolean());
    }
}

