/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.net;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.mina.core.session.IoSession;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.InvalidSessionException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.OperationParameters;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.net.MessageHelper;
import org.eclipse.scada.core.server.Session;
import org.eclipse.scada.core.server.net.AbstractServerConnectionHandler;
import org.eclipse.scada.da.core.Location;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.core.browser.Entry;
import org.eclipse.scada.da.core.server.Hive;
import org.eclipse.scada.da.core.server.InvalidItemException;
import org.eclipse.scada.da.core.server.ItemChangeListener;
import org.eclipse.scada.da.core.server.Session;
import org.eclipse.scada.da.core.server.browser.FolderListener;
import org.eclipse.scada.da.core.server.browser.HiveBrowser;
import org.eclipse.scada.da.core.server.browser.NoSuchFolderException;
import org.eclipse.scada.da.net.handler.ListBrowser;
import org.eclipse.scada.da.net.handler.Messages;
import org.eclipse.scada.da.net.handler.WriteAttributesOperation;
import org.eclipse.scada.da.net.handler.WriteOperation;
import org.eclipse.scada.net.base.MessageListener;
import org.eclipse.scada.net.base.data.LongValue;
import org.eclipse.scada.net.base.data.Message;
import org.eclipse.scada.net.base.data.StringValue;
import org.eclipse.scada.net.base.data.Value;
import org.eclipse.scada.net.utils.MessageCreator;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.callback.PropertiesCredentialsCallback;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.concurrent.task.DefaultTaskHandler;
import org.eclipse.scada.utils.concurrent.task.ResultFutureHandler;
import org.eclipse.scada.utils.concurrent.task.ResultHandler;
import org.eclipse.scada.utils.concurrent.task.TaskHandler;
import org.eclipse.scada.utils.lang.Holder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConnectionHandler
extends AbstractServerConnectionHandler
implements ItemChangeListener,
FolderListener {
    public static final String VERSION = "0.1.8";
    private static final Logger logger = LoggerFactory.getLogger(ServerConnectionHandler.class);
    private Hive hive = null;
    private Session session = null;
    private final TaskHandler taskHandler = new DefaultTaskHandler();
    private final Set<Long> taskMap = new HashSet<Long>();

    public ServerConnectionHandler(Hive hive, IoSession ioSession, ConnectionInformation connectionInformation) {
        super(ioSession, connectionInformation);
        this.hive = hive;
        this.messenger.setHandler(65537, new MessageListener(){

            public void messageReceived(Message message) {
                ServerConnectionHandler.this.createSession(message);
            }
        });
        this.messenger.setHandler(65538, new MessageListener(){

            public void messageReceived(Message message) {
                ServerConnectionHandler.this.closeSession();
            }
        });
        this.messenger.setHandler(65552, new MessageListener(){

            public void messageReceived(Message message) {
                ServerConnectionHandler.this.subscribe(message);
            }
        });
        this.messenger.setHandler(65553, new MessageListener(){

            public void messageReceived(Message message) {
                ServerConnectionHandler.this.unsubscribe(message);
            }
        });
        this.messenger.setHandler(65584, new MessageListener(){

            public void messageReceived(Message message) {
                ServerConnectionHandler.this.performWrite(message);
            }
        });
        this.messenger.setHandler(65616, new MessageListener(){

            public void messageReceived(Message message) {
                ServerConnectionHandler.this.performWriteAttributes(message);
            }
        });
        this.messenger.setHandler(66048, new MessageListener(){

            public void messageReceived(Message message) {
                ServerConnectionHandler.this.performBrowse(message);
            }
        });
        this.messenger.setHandler(66065, new MessageListener(){

            public void messageReceived(Message message) {
                ServerConnectionHandler.this.performBrowserSubscribe(message);
            }
        });
        this.messenger.setHandler(66066, new MessageListener(){

            public void messageReceived(Message message) {
                ServerConnectionHandler.this.performBrowserUnsubscribe(message);
            }
        });
    }

    private void createSession(final Message message) {
        if (this.session != null) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"Connection already bound to a session"));
            return;
        }
        final Properties props = new Properties();
        MessageHelper.getProperties((Properties)props, (Value)message.getValues().get("properties"));
        this.debugSessionDelay(props);
        String clientVersion = props.getProperty("client-version", "");
        if (clientVersion.equals("")) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"client does not pass \"client-version\" property! You may need to upgrade your client!"));
            return;
        }
        if (!clientVersion.equals(VERSION)) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)String.format("protocol version mismatch: client '%s' server: '%s'", clientVersion, VERSION)));
            return;
        }
        this.hive.createSession(props, (CallbackHandler)new PropertiesCredentialsCallback(props)).addListener((FutureListener)new FutureListener<Session>(){

            public void complete(Future<Session> future) {
                ServerConnectionHandler.this.handleCreateSessionComplete(future, message, props);
            }
        });
    }

    protected void handleCreateSessionComplete(Future<Session> future, Message message, Properties props) {
        try {
            this.session = future.get();
        }
        catch (Exception e) {
            logger.warn("Failed to create session", (Throwable)e);
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (Throwable)e));
            return;
        }
        if (this.session == null) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"unable to create session"));
            return;
        }
        this.session.setListener((ItemChangeListener)this);
        this.session.setListener((FolderListener)this);
        this.replySessionCreated(props, message, this.session.getProperties());
        this.session.addSessionListener(new Session.SessionListener(){

            public void privilegeChange() {
                ServerConnectionHandler.this.sendPrivilegeChange(ServerConnectionHandler.this.session.getPrivileges());
            }
        });
    }

    private void debugSessionDelay(Properties props) {
        try {
            String delayString = props.getProperty("debug.sessionDelay");
            if (delayString == null || delayString.isEmpty()) {
                return;
            }
            long delay = Long.parseLong(delayString);
            if (delay > 0L) {
                logger.warn("Delaying session creation by {} ms", (Object)delay);
                Thread.sleep(delay);
            }
        }
        catch (Exception exception) {}
    }

    private void disposeSession() {
        if (this.session != null) {
            try {
                this.hive.closeSession((org.eclipse.scada.core.server.Session)this.session);
            }
            catch (InvalidSessionException e) {
                logger.warn("Failed to close session", (Throwable)e);
            }
        }
    }

    private void closeSession() {
        this.cleanUp();
    }

    private void subscribe(Message message) {
        if (this.session == null) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"No session"));
            return;
        }
        String itemName = message.getValues().get("item-id").toString();
        boolean initial = message.getValues().containsKey("cache-read");
        logger.debug("Subscribe to {} initial {}", (Object)itemName, (Object)initial);
        try {
            this.hive.subscribeItem(this.session, itemName);
        }
        catch (InvalidSessionException invalidSessionException) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"Invalid session"));
        }
        catch (InvalidItemException invalidItemException) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"Invalid item"));
        }
    }

    private void unsubscribe(Message message) {
        if (this.session == null) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"No session"));
            return;
        }
        String itemName = message.getValues().get("item-id").toString();
        try {
            this.hive.unsubscribeItem(this.session, itemName);
        }
        catch (InvalidSessionException invalidSessionException) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"Invalid session"));
        }
        catch (InvalidItemException invalidItemException) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"Invalid item"));
        }
    }

    protected void cleanUp() {
        super.cleanUp();
        this.disposeSession();
    }

    public void dataChanged(String itemId, Variant value, Map<String, Variant> attributes, boolean cache) {
        logger.debug("Data changed - itemId: {}, value: {}, attributes: {}, cache: {}", new Object[]{itemId, value, attributes, cache});
        this.messenger.sendMessage(Messages.notifyData((String)itemId, (Variant)value, attributes, (boolean)cache));
    }

    public void subscriptionChanged(String item, SubscriptionState subscriptionState) {
        this.messenger.sendMessage(Messages.notifySubscriptionChange((String)item, (SubscriptionState)subscriptionState));
    }

    private void performWrite(Message request) {
        Holder itemId = new Holder();
        Holder value = new Holder();
        Holder operationParameters = new Holder();
        WriteOperation.parse((Message)request, (Holder)itemId, (Holder)value, (Holder)operationParameters);
        try {
            NotifyFuture task = this.hive.startWrite(this.session, (String)itemId.value, (Variant)value.value, (OperationParameters)operationParameters.value, null);
            final TaskHandler.Handle handle = this.taskHandler.addTask(task);
            try {
                Message reply = MessageCreator.createACK((Message)request);
                reply.getValues().put("id", (Value)new LongValue(handle.getId().longValue()));
                this.messenger.sendMessage(reply);
            }
            catch (Throwable e) {
                task.cancel(true);
                throw e;
            }
            this.scheduleTask(task, handle.getId(), new ResultHandler<WriteResult>(){

                public void completed(WriteResult result) {
                    Message replyMessage = new Message(65585);
                    replyMessage.getValues().put("id", (Value)new LongValue(handle.getId().longValue()));
                    ServerConnectionHandler.this.messenger.sendMessage(replyMessage);
                    handle.dispose();
                }

                public void failed(Throwable e) {
                    logger.debug("Failed to process write request", e);
                    Message replyMessage = new Message(65585);
                    replyMessage.getValues().put("error-info", (Value)new StringValue(e.getMessage()));
                    replyMessage.getValues().put("id", (Value)new LongValue(handle.getId().longValue()));
                    ServerConnectionHandler.this.messenger.sendMessage(replyMessage);
                    handle.dispose();
                }
            });
        }
        catch (Throwable e) {
            logger.debug(String.format("Failed to write to item: %s", itemId.value), e);
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)request, (Throwable)e));
        }
    }

    private <T> void scheduleTask(NotifyFuture<T> task, long id, ResultHandler<T> resultHandler) {
        task.addListener((FutureListener)new ResultFutureHandler(resultHandler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTask(long id) {
        Set<Long> set = this.taskMap;
        synchronized (set) {
            this.taskMap.remove(id);
        }
    }

    private void performWriteAttributes(Message request) {
        Holder itemId = new Holder();
        Holder attributes = new Holder();
        Holder operationParameters = new Holder();
        WriteAttributesOperation.parseRequest((Message)request, (Holder)itemId, (Holder)attributes, (Holder)operationParameters);
        try {
            NotifyFuture task = this.hive.startWriteAttributes(this.session, (String)itemId.value, (Map)attributes.value, (OperationParameters)operationParameters.value, null);
            final TaskHandler.Handle handle = this.taskHandler.addTask(task);
            try {
                Message reply = MessageCreator.createACK((Message)request);
                reply.getValues().put("id", (Value)new LongValue(handle.getId().longValue()));
                this.messenger.sendMessage(reply);
            }
            catch (Throwable e) {
                task.cancel(true);
                throw e;
            }
            this.scheduleTask(task, handle.getId(), new ResultHandler<WriteAttributeResults>(){

                public void completed(WriteAttributeResults result) {
                    Message message = WriteAttributesOperation.createResponse((long)handle.getId(), (WriteAttributeResults)result);
                    ServerConnectionHandler.this.messenger.sendMessage(message);
                    handle.dispose();
                }

                public void failed(Throwable e) {
                    Message message = WriteAttributesOperation.createResponse((long)handle.getId(), (Throwable)e);
                    ServerConnectionHandler.this.messenger.sendMessage(message);
                    handle.dispose();
                }
            });
        }
        catch (Throwable e) {
            logger.debug(String.format("Failed to write attributes to item: %s", itemId.value), e);
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)request, (Throwable)e));
        }
    }

    private void performBrowse(Message request) {
        String[] location = ListBrowser.parseRequest((Message)request);
        HiveBrowser browser = this.hive.getBrowser();
        if (browser == null) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)request, (String)"Browsing not supported"));
            return;
        }
        try {
            NotifyFuture task = browser.startBrowse(this.session, new Location(location));
            final TaskHandler.Handle handle = this.taskHandler.addTask(task);
            try {
                Message reply = MessageCreator.createACK((Message)request);
                reply.getValues().put("id", (Value)new LongValue(handle.getId().longValue()));
                this.messenger.sendMessage(reply);
            }
            catch (Throwable e) {
                this.removeTask(handle.getId());
                task.cancel(true);
                throw e;
            }
            this.scheduleTask(task, handle.getId(), new ResultHandler<Entry[]>(){

                public void completed(Entry[] result) {
                    ServerConnectionHandler.this.messenger.sendMessage(ListBrowser.createResponse((long)handle.getId(), (Entry[])result));
                    handle.dispose();
                }

                public void failed(Throwable e) {
                    ServerConnectionHandler.this.messenger.sendMessage(ListBrowser.createResponse((long)handle.getId(), (String)e.getMessage()));
                    handle.dispose();
                }
            });
        }
        catch (Throwable e) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)request, (Throwable)e));
        }
    }

    public void folderChanged(Location location, List<Entry> added, Set<String> removed, boolean full) {
        logger.debug("Got folder change event from hive for folder: {}", (Object)location);
        this.messenger.sendMessage(ListBrowser.createEvent((String[])location.asArray(), added, removed, (boolean)full));
    }

    private void performBrowserSubscribe(Message message) {
        HiveBrowser browser = this.hive.getBrowser();
        if (browser == null) {
            logger.warn("Unable to subscribe to folder: no hive browser set");
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"Interface not supported"));
            return;
        }
        Location location = new Location(ListBrowser.parseSubscribeMessage((Message)message));
        try {
            logger.debug("Subscribe to folder: {}", (Object)location.toString());
            browser.subscribe(this.session, location);
        }
        catch (NoSuchFolderException e) {
            logger.warn("Unable to subscribe to folder: " + location, (Throwable)e);
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"Folder not found"));
            return;
        }
        catch (InvalidSessionException e) {
            logger.warn("Unable to subscribe to folder: " + location, (Throwable)e);
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"Invalid session"));
            return;
        }
        catch (Exception e) {
            logger.warn("Browsing failed", (Throwable)e);
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (Throwable)e));
            return;
        }
    }

    private void performBrowserUnsubscribe(Message message) {
        HiveBrowser browser = this.hive.getBrowser();
        if (browser == null) {
            logger.warn("Unable to unsubscribe from folder: no hive browser set");
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"Interface not supported"));
            return;
        }
        Location location = new Location(ListBrowser.parseUnsubscribeMessage((Message)message));
        try {
            logger.debug("Unsubscribe from folder: {}", (Object)location.toString());
            browser.unsubscribe(this.session, location);
        }
        catch (NoSuchFolderException noSuchFolderException) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"Folder not found"));
            return;
        }
        catch (InvalidSessionException invalidSessionException) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"Invalid session"));
            return;
        }
    }
}

