/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.sfp.strategy;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.da.client.FolderListener;
import org.eclipse.scada.da.client.sfp.ConnectionHandler;
import org.eclipse.scada.da.client.sfp.strategy.Folder;
import org.eclipse.scada.da.core.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderManager {
    private static final Logger logger = LoggerFactory.getLogger(FolderManager.class);
    private final ConnectionHandler connectionHandler;
    private final Folder rootFolder;
    private final Map<Location, FolderListener> folderListeners = new HashMap<Location, FolderListener>();

    public FolderManager(ConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
        this.rootFolder = new Folder(connectionHandler.getExecutor(), null, new Location());
    }

    public void dispose() {
        this.rootFolder.dispose();
    }

    public void subscribeFolder(Location location) {
    }

    public void unsubscribeFolder(Location location) {
    }

    public void addEntry(Location location, String name, String itemId, String description) {
        Folder folder = this.rootFolder.findFolder(location.getPathStack(), true);
        folder.addItemEntry(name, itemId, description);
    }

    public void removeEntry(Location location, String name) {
        Folder folder = this.rootFolder.findFolder(location.getPathStack(), false);
        if (folder == null) {
            return;
        }
        folder.removeItemEntry(name);
    }

    public void setFolderListener(Location location, FolderListener listener) {
        logger.debug("Setting folder listener - location: {}, listener: {}", (Object)location, (Object)listener);
        this.folderListeners.put(location, listener);
        Folder folder = this.rootFolder.findFolder(location.getPathStack(), false);
        if (folder != null) {
            folder.setListener(listener);
        }
    }

    protected void execute(Runnable command) {
        this.connectionHandler.getExecutor().execute(command);
    }
}

