/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.item;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.AttributesHelper;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.connection.provider.ConnectionIdTracker;
import org.eclipse.scada.core.connection.provider.ConnectionTracker;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.core.server.OperationParametersHelper;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.client.ItemUpdateListener;
import org.eclipse.scada.da.connection.provider.ConnectionService;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.datasource.base.AbstractDataSource;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItemSourceImpl
extends AbstractDataSource
implements ItemUpdateListener {
    private static final Logger logger = LoggerFactory.getLogger(DataItemSourceImpl.class);
    private String itemId;
    private String connectionId;
    private final BundleContext context;
    private ConnectionIdTracker tracker;
    private ConnectionService connection;
    private DataItemValue sourceValue;
    private final Executor executor;
    private boolean debug;

    public DataItemSourceImpl(BundleContext context, Executor executor) {
        this.context = context;
        this.executor = executor;
        this.fireValueChange(new DataItemValue.Builder());
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    public synchronized void dispose() {
        this.disconnect();
    }

    private void disconnect() {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
    }

    public synchronized void update(Map<String, String> parameters) {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        this.disconnect();
        this.itemId = cfg.getStringChecked("item.id", "'item.id' must be set");
        this.connectionId = cfg.getStringChecked("connection.id", "'connection.id' must be checked");
        this.debug = cfg.getBoolean("debug", false);
        this.connect();
    }

    private void connect() {
        this.tracker = new ConnectionIdTracker(this.context, this.connectionId, new ConnectionTracker.Listener(){

            public void setConnection(org.eclipse.scada.core.connection.provider.ConnectionService connectionService) {
                DataItemSourceImpl.this.setConnection((ConnectionService)connectionService);
            }
        }, ConnectionService.class);
        this.tracker.open();
    }

    protected synchronized void setConnection(ConnectionService connectionService) {
        logger.info("Set connection: {}", (Object)connectionService);
        if (this.connection == connectionService) {
            return;
        }
        if (this.connection != null) {
            this.connection.getItemManager().removeItemUpdateListener(this.itemId, (ItemUpdateListener)this);
        }
        this.connection = connectionService;
        this.fireValueChange(new DataItemValue.Builder());
        if (this.connection != null) {
            this.connection.getItemManager().addItemUpdateListener(this.itemId, (ItemUpdateListener)this);
        }
    }

    private void fireValueChange(DataItemValue.Builder builder) {
        this.injectAttributes(builder);
        this.sourceValue = builder.build();
        this.updateData(this.sourceValue);
    }

    public synchronized void notifyDataChange(Variant value, Map<String, Variant> attributes, boolean cache) {
        logger.debug("Data update: {} -> {} / {} (cache: {})", new Object[]{this.itemId, value, attributes, cache});
        this.fireValueChange(this.applyDataChange(value, attributes, cache));
    }

    private DataItemValue.Builder applyDataChange(Variant value, Map<String, Variant> attributes, boolean cache) {
        DataItemValue.Builder newValue = new DataItemValue.Builder(this.sourceValue);
        HashMap oldAttributes = cache ? new HashMap() : new HashMap(newValue.getAttributes());
        if (value != null) {
            newValue.setValue(value);
        }
        if (attributes != null) {
            AttributesHelper.mergeAttributes(oldAttributes, attributes, (boolean)cache);
            newValue.setAttributes(oldAttributes);
        }
        this.injectAttributes(newValue);
        return newValue;
    }

    private void injectAttributes(DataItemValue.Builder newValue) {
        if (this.debug) {
            newValue.setAttribute("source.hasConnection", this.connection != null ? Variant.TRUE : Variant.FALSE);
            newValue.setAttribute("source.item.subscriptionState", Variant.valueOf((Object)newValue.getSubscriptionState().toString()));
        }
        newValue.setAttribute("source.itemId", Variant.valueOf((Object)this.itemId));
        newValue.setAttribute("source.connectionId", Variant.valueOf((Object)this.connectionId));
        newValue.setAttribute("source.error", newValue.getSubscriptionState() != SubscriptionState.CONNECTED ? Variant.TRUE : Variant.FALSE);
    }

    public synchronized void notifySubscriptionChange(SubscriptionState state, Throwable error) {
        logger.info("Subscription state changed: {}", (Object)state);
        this.fireValueChange(this.applyStateChange(this.sourceValue, state, error));
    }

    private DataItemValue.Builder applyStateChange(DataItemValue sourceValue, SubscriptionState state, Throwable error) {
        DataItemValue.Builder newValue = new DataItemValue.Builder(sourceValue);
        newValue.setSubscriptionState(state);
        newValue.setSubscriptionError(error);
        this.injectAttributes(newValue);
        return newValue;
    }

    public synchronized NotifyFuture<WriteResult> startWriteValue(Variant value, OperationParameters operationParameters) {
        ConnectionService connection = this.connection;
        if (connection != null) {
            return connection.getConnection().startWrite(this.itemId, value, OperationParametersHelper.toData((OperationParameters)operationParameters), this.getHandler(operationParameters));
        }
        return new InstantErrorFuture(new OperationException("No connection").fillInStackTrace());
    }

    public synchronized NotifyFuture<WriteAttributeResults> startWriteAttributes(Map<String, Variant> attributes, OperationParameters operationParameters) {
        ConnectionService connection = this.connection;
        if (connection != null) {
            return connection.getConnection().startWriteAttributes(this.itemId, attributes, OperationParametersHelper.toData((OperationParameters)operationParameters), this.getHandler(operationParameters));
        }
        return new InstantErrorFuture(new OperationException("No connection").fillInStackTrace());
    }

    private CallbackHandler getHandler(OperationParameters operationParameters) {
        return operationParameters == null ? null : operationParameters.getCallbackHandler();
    }
}

