/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.monitor.proxy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.server.monitor.proxy.ProxyMonitorQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractMonitorQueryListener {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMonitorQueryListener.class);
    private final Map<String, MonitorStatusInformation> dataCache = new HashMap<String, MonitorStatusInformation>();
    protected final Lock lock;
    private final ProxyMonitorQuery proxyMonitorQuery;
    protected final String info;
    private boolean disposed;

    public AbstractMonitorQueryListener(ProxyMonitorQuery proxyMonitorQuery, Lock lock, String info) {
        this.lock = lock;
        this.proxyMonitorQuery = proxyMonitorQuery;
        this.info = info;
    }

    protected void clearAll() {
        this.lock.lock();
        try {
            this.performClearAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void performClearAll() {
        HashSet<String> removed = new HashSet<String>(this.dataCache.keySet());
        this.dataCache.clear();
        this.notifyChange(null, removed);
    }

    protected void handleDataChanged(List<MonitorStatusInformation> addedOrUpdated, Set<String> removed, boolean full) {
        logger.debug("Data of {} changed - added: @{}, removed: @{}", new Object[]{this.info, addedOrUpdated == null ? -1 : addedOrUpdated.size(), removed == null ? -1 : removed.size()});
        this.lock.lock();
        try {
            HashSet<String> removedIds = new HashSet<String>();
            if (full) {
                removedIds.addAll(this.dataCache.keySet());
                this.dataCache.clear();
            }
            if (addedOrUpdated != null) {
                for (MonitorStatusInformation info : addedOrUpdated) {
                    this.dataCache.put(info.getId(), info);
                    if (!full) continue;
                    removedIds.remove(info.getId());
                }
            }
            if (removed != null) {
                for (String id : removed) {
                    if (this.dataCache.remove(id) == null) continue;
                    removedIds.add(id);
                }
            }
            this.notifyChange(addedOrUpdated, removed);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void notifyChange(List<MonitorStatusInformation> addedOrUpdated, Set<String> removed) {
        if (this.disposed) {
            logger.info("We are disposed. Discard event");
            return;
        }
        this.proxyMonitorQuery.handleDataUpdate(addedOrUpdated, removed);
    }

    public void dispose() {
        this.lock.lock();
        if (this.disposed) {
            return;
        }
        this.performClearAll();
        try {
            this.disposed = true;
        }
        finally {
            this.lock.unlock();
        }
    }
}

