/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter;

import org.eclipse.scada.da.server.exporter.Controller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    private static final Logger logger = LoggerFactory.getLogger(Application.class);
    private static volatile boolean running = true;
    private static volatile boolean active = false;
    private static Object activeLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        active = true;
        String configurationFile = "configuration.xml";
        if (args.length > 0) {
            configurationFile = args[0];
        }
        logger.info("Loading configuration file: {}", (Object)configurationFile);
        Controller controller = new Controller(configurationFile);
        controller.start();
        logger.info("Exporter running...");
        while (running) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.warn("Failed to sleep", (Throwable)e);
                Thread.interrupted();
            }
        }
        logger.info("Stopping controller");
        controller.stop();
        logger.info("Stop complete");
        Object object = activeLock;
        synchronized (object) {
            logger.info("Signal shutdown");
            active = false;
            activeLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        running = false;
        long timeout = Long.getLong("org.eclipse.scada.da.server.exporter.shutdownPeriod", 15000L);
        long start = System.currentTimeMillis();
        Object object = activeLock;
        synchronized (object) {
            while (active) {
                if (System.currentTimeMillis() - start > timeout) {
                    logger.warn("Timeout wainting for shutdown. Force exit!");
                    System.exit(0);
                    return;
                }
                try {
                    activeLock.wait(1000L);
                }
                catch (InterruptedException e) {
                    logger.warn("Failed to wait for shutdown", (Throwable)e);
                    return;
                }
                logger.info("Still waiting for shutdown...");
            }
        }
    }

    public static void stop(String[] args) {
        Application.stop();
    }
}

