/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.formula;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.scada.ca.common.factory.AbstractServiceConfigurationFactory;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.formula.FormulaDataSource;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormulaSourceFactory
extends AbstractServiceConfigurationFactory<FormulaDataSource> {
    private static final Logger logger = LoggerFactory.getLogger(FormulaSourceFactory.class);
    private final ScheduledExecutorService executor;
    private final ObjectPoolTracker<DataSource> poolTracker;
    private final ObjectPoolImpl<DataSource> objectPool;
    private final ServiceRegistration<?> poolRegistration;

    public FormulaSourceFactory(BundleContext context, ScheduledExecutorService executor) throws InvalidSyntaxException {
        super(context);
        this.executor = executor;
        this.objectPool = new ObjectPoolImpl();
        this.poolRegistration = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.objectPool, DataSource.class);
        this.poolTracker = new ObjectPoolTracker(context, DataSource.class);
        this.poolTracker.open();
    }

    public synchronized void dispose() {
        this.poolRegistration.unregister();
        this.objectPool.dispose();
        this.poolTracker.close();
        super.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<FormulaDataSource> createService(UserInformation userInformation, String configurationId, BundleContext context, Map<String, String> parameters) throws Exception {
        FormulaDataSource source = new FormulaDataSource(context, this.poolTracker, this.executor);
        source.update(parameters);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("datasource.id", configurationId);
        this.objectPool.addService(configurationId, (Object)source, properties);
        return new AbstractServiceConfigurationFactory.Entry(configurationId, (Object)source);
    }

    protected void disposeService(UserInformation userInformation, String id, FormulaDataSource service) {
        logger.info("Disposing: {}", (Object)id);
        this.objectPool.removeService(id, (Object)service);
        service.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<FormulaDataSource> updateService(UserInformation userInformation, String configurationId, AbstractServiceConfigurationFactory.Entry<FormulaDataSource> entry, Map<String, String> parameters) throws Exception {
        ((FormulaDataSource)((Object)entry.getService())).update(parameters);
        return null;
    }
}

