/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.buffer.internal;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.scada.ca.common.factory.AbstractServiceConfigurationFactory;
import org.eclipse.scada.da.buffer.BufferedDataSource;
import org.eclipse.scada.da.buffer.internal.BufferedDataSourceImpl;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.ds.DataNodeTracker;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedDatasourceFactory
extends AbstractServiceConfigurationFactory<BufferedDataSource> {
    private static final Logger logger = LoggerFactory.getLogger(BufferedDatasourceFactory.class);
    private final BundleContext context;
    private final ScheduledExecutorService executor;
    private final ObjectPoolTracker<DataSource> poolTracker;
    private final ObjectPoolImpl<BufferedDataSource> objectPool;
    private final ServiceRegistration<?> poolRegistration;
    private DataNodeTracker dataNodeTracker;

    public BufferedDatasourceFactory(BundleContext context, ScheduledExecutorService executor) throws InvalidSyntaxException {
        super(context);
        this.context = context;
        this.executor = executor;
        this.objectPool = new ObjectPoolImpl();
        this.poolRegistration = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.objectPool, BufferedDataSource.class);
        this.poolTracker = new ObjectPoolTracker(context, DataSource.class.getName());
        this.poolTracker.open();
        this.dataNodeTracker = new DataNodeTracker(context);
        this.dataNodeTracker.open();
    }

    public synchronized void dispose() {
        this.poolRegistration.unregister();
        this.objectPool.dispose();
        this.poolTracker.close();
        this.dataNodeTracker.close();
        super.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<BufferedDataSource> createService(UserInformation userInformation, String configurationId, BundleContext context, Map<String, String> parameters) throws Exception {
        logger.debug("Creating new change counter source: {}", (Object)configurationId);
        BufferedDataSourceImpl source = new BufferedDataSourceImpl(this.context, this.executor, this.poolTracker, this.dataNodeTracker, configurationId, this.objectPool);
        source.update(parameters);
        return new AbstractServiceConfigurationFactory.Entry(configurationId, (Object)source);
    }

    protected void disposeService(UserInformation userInformation, String configurationId, BufferedDataSource service) {
        logger.info("Disposing: {}", (Object)configurationId);
        this.objectPool.removeService(configurationId, (Object)service);
        ((BufferedDataSourceImpl)service).dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<BufferedDataSource> updateService(UserInformation userInformation, String configurationId, AbstractServiceConfigurationFactory.Entry<BufferedDataSource> entry, Map<String, String> parameters) throws Exception {
        ((BufferedDataSourceImpl)entry.getService()).update(parameters);
        return null;
    }
}

