/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.ngp;

import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.da.core.server.Hive;
import org.eclipse.scada.da.server.ngp.Exporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    private static final Logger logger = LoggerFactory.getLogger(Application.class);

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                System.err.println("syntax: Application <hiveClassName>");
                return;
            }
            ConnectionInformation ci = null;
            if (args.length >= 2) {
                ci = ConnectionInformation.fromURI((String)args[1]);
            }
            if (ci == null) {
                ci = ConnectionInformation.fromURI((String)("da:ngp://0.0.0.0:" + System.getProperty("openscada.da.ngp.server.port", "2101")));
            }
            Class<?> hiveClass = Class.forName(args[0]);
            Hive service = (Hive)hiveClass.newInstance();
            Exporter exporter = new Exporter(service, ci);
            service.start();
            exporter.start();
            logger.info("Running exporter (hive class: " + exporter.getServiceClass().getCanonicalName() + ")...");
        }
        catch (Throwable e) {
            logger.error("Error in openSCADA HD[NGP] Server", e);
            System.exit(1);
        }
    }
}

