/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.monitor.datasource;

import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ae.monitor.MonitorService;
import org.eclipse.scada.ae.monitor.common.DataItemMonitor;
import org.eclipse.scada.ae.server.common.akn.AknHandler;
import org.eclipse.scada.ca.common.factory.AbstractServiceConfigurationFactory;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ManageableObjectPool;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMonitorFactory
extends AbstractServiceConfigurationFactory<DataItemMonitor>
implements AknHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMonitorFactory.class);
    protected final BundleContext context;
    protected final EventProcessor eventProcessor;
    private final ManageableObjectPool<MonitorService> servicePool;

    protected abstract DataItemMonitor createInstance(String var1, EventProcessor var2);

    public AbstractMonitorFactory(BundleContext context, ManageableObjectPool<MonitorService> servicePool, EventProcessor eventProcessor) {
        super(context);
        this.context = context;
        this.servicePool = servicePool;
        this.eventProcessor = eventProcessor;
    }

    protected AbstractServiceConfigurationFactory.Entry<DataItemMonitor> createService(UserInformation userInformation, String configurationId, BundleContext context, Map<String, String> parameters) throws Exception {
        DataItemMonitor instance = this.createInstance(configurationId, this.eventProcessor);
        instance.update(userInformation, parameters);
        Hashtable properties = new Hashtable();
        this.servicePool.addService(configurationId, (Object)instance, properties);
        return new AbstractServiceConfigurationFactory.Entry(configurationId, (Object)instance);
    }

    protected void disposeService(UserInformation userInformation, String id, DataItemMonitor service) {
        this.servicePool.removeService(id, (Object)service);
        service.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<DataItemMonitor> updateService(UserInformation userInformation, String configurationId, AbstractServiceConfigurationFactory.Entry<DataItemMonitor> entry, Map<String, String> parameters) throws Exception {
        ((DataItemMonitor)entry.getService()).update(userInformation, parameters);
        return null;
    }

    public synchronized boolean acknowledge(String monitorId, OperationParameters operationParameters, Date aknTimestamp) {
        logger.debug("Try to process ACK: {}", (Object)monitorId);
        AbstractServiceConfigurationFactory.Entry entry = this.getService(monitorId);
        if (entry != null) {
            ((DataItemMonitor)entry.getService()).akn(operationParameters == null ? null : operationParameters.getUserInformation(), aknTimestamp);
            return true;
        }
        logger.info("Monitor '{}' could not be found in this factory ({})", (Object)monitorId, ((Object)((Object)this)).getClass());
        return false;
    }
}

