/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.ngp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.mina.core.session.IoSession;
import org.eclipse.scada.core.InvalidSessionException;
import org.eclipse.scada.core.data.ErrorInformation;
import org.eclipse.scada.core.data.Response;
import org.eclipse.scada.core.server.ngp.ServiceServerConnection;
import org.eclipse.scada.hd.InvalidItemException;
import org.eclipse.scada.hd.ItemListListener;
import org.eclipse.scada.hd.Query;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.QueryState;
import org.eclipse.scada.hd.data.HistoricalItemInformation;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.data.ValueEntry;
import org.eclipse.scada.hd.data.ValueInformation;
import org.eclipse.scada.hd.data.message.ChangeQueryParameters;
import org.eclipse.scada.hd.data.message.CloseQuery;
import org.eclipse.scada.hd.data.message.CreateQuery;
import org.eclipse.scada.hd.data.message.CreateQueryFailure;
import org.eclipse.scada.hd.data.message.ListUpdate;
import org.eclipse.scada.hd.data.message.StartBrowse;
import org.eclipse.scada.hd.data.message.StopBrowse;
import org.eclipse.scada.hd.data.message.UpdateQueryData;
import org.eclipse.scada.hd.data.message.UpdateQueryParameters;
import org.eclipse.scada.hd.data.message.UpdateQueryState;
import org.eclipse.scada.hd.server.Service;
import org.eclipse.scada.hd.server.Session;
import org.eclipse.scada.hd.server.ngp.QueryHandler;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.profiler.Profiler;

public class ServerConnectionImpl
extends ServiceServerConnection<Session, Service> {
    private static final Logger logger = LoggerFactory.getLogger(ServerConnectionImpl.class);
    private final Map<Long, QueryHandler> queries = new HashMap<Long, QueryHandler>();
    private final ExecutorService queryDisposer;
    private final ItemListListener listener = new ItemListListener(){

        public void listChanged(Set<HistoricalItemInformation> addedOrModified, Set<String> removed, boolean full) {
            ServerConnectionImpl.this.handleListChanged(addedOrModified, removed, full);
        }
    };

    public ServerConnectionImpl(IoSession session, Service service) {
        super(session, (org.eclipse.scada.core.server.Service)service);
        this.queryDisposer = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("org.eclipse.scada.hd.server.ngp.QueryDisposer"));
    }

    protected int getMaxDataSize() {
        return Integer.getInteger("org.eclipse.scada.hd.server.ngp.maxDataSize", 1024);
    }

    public void dispose() {
        super.dispose();
        this.queryDisposer.shutdown();
    }

    public void messageReceived(Object message) throws Exception {
        if (message instanceof StartBrowse) {
            this.handleStartBrowse();
        } else if (message instanceof StopBrowse) {
            this.handelStopBrowse();
        } else if (message instanceof CloseQuery) {
            this.handleCloseQuery((CloseQuery)message);
        } else if (message instanceof CreateQuery) {
            this.handleCreateQuery((CreateQuery)message);
        } else if (message instanceof ChangeQueryParameters) {
            this.handleChangeQueryParameters((ChangeQueryParameters)message);
        } else {
            super.messageReceived(message);
        }
    }

    private void handelStopBrowse() {
        logger.debug("Stopping browser");
        ((Session)this.session).setItemListListener(null);
    }

    private void handleStartBrowse() {
        logger.debug("Starting browser");
        ((Session)this.session).setItemListListener(this.listener);
    }

    protected void handleListChanged(Set<HistoricalItemInformation> addedOrModified, Set<String> removed, boolean full) {
        logger.debug("List changed - addedOrModified: {}, removed: {}, full: {}", new Object[]{addedOrModified, removed, full});
        this.sendMessage(new ListUpdate(addedOrModified, removed, full));
    }

    protected synchronized void handleChangeQueryParameters(ChangeQueryParameters message) {
        long queryId = message.getQueryId();
        QueryHandler handler = this.queries.get(queryId);
        if (handler != null) {
            handler.changeParameters(message.getQueryParameters());
        }
    }

    protected synchronized void handleCloseQuery(CloseQuery message) {
        Profiler p = new Profiler("Close Query");
        p.setLogger(logger);
        p.start("init");
        final long queryId = message.getQueryId();
        logger.info("Handle close query: {}", (Object)queryId);
        p.start("remove");
        this.sendQueryState(queryId, QueryState.DISCONNECTED);
        final QueryHandler handler = this.queries.remove(queryId);
        if (handler != null) {
            p.start("Close");
            this.queryDisposer.execute(new Runnable(){

                @Override
                public void run() {
                    logger.info("Disposing query {} ...", (Object)queryId);
                    handler.close();
                    logger.info("Disposing query {} ... done!", (Object)queryId);
                }
            });
        }
        p.stop().log();
    }

    protected void handleCreateQuery(CreateQuery message) {
        Profiler p = new Profiler("Create query");
        p.setLogger(logger);
        long queryId = message.getQueryId();
        logger.debug("Creating new query with id: {}", (Object)queryId);
        try {
            try {
                p.start("Prepare");
                String itemId = message.getItemId();
                QueryParameters parameters = message.getQueryParameters();
                boolean updateData = message.isUpdateData();
                p.start("Make query");
                this.makeQuery(message, queryId, itemId, parameters, updateData);
                p.start("Finish");
            }
            catch (Throwable throwable) {
                this.sendQueryState(queryId, QueryState.DISCONNECTED);
                p.stop().log();
            }
        }
        finally {
            p.stop().log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeQuery(CreateQuery message, long queryId, String itemId, QueryParameters parameters, boolean updateData) throws InvalidSessionException, InvalidItemException {
        QueryHandler handler;
        ServerConnectionImpl serverConnectionImpl = this;
        synchronized (serverConnectionImpl) {
            if (this.queries.containsKey(queryId)) {
                logger.warn("Duplicate query request: {}", (Object)queryId);
                this.sendMessage(new CreateQueryFailure(new Response(message.getRequest()), new ErrorInformation(null, String.format("Duplicate query id: %s", queryId), null)));
                return;
            }
            handler = new QueryHandler(queryId, this);
            this.queries.put(queryId, handler);
        }
        Query query = ((Service)this.service).createQuery((Session)this.session, itemId, parameters, (QueryListener)handler, updateData);
        if (query == null) {
            ServerConnectionImpl serverConnectionImpl2 = this;
            synchronized (serverConnectionImpl2) {
                this.sendQueryState(queryId, QueryState.DISCONNECTED);
                this.queries.remove(queryId);
            }
        } else {
            logger.debug("Adding query: {}", (Object)queryId);
            handler.setQuery(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendQueryData(long queryId, int index, Map<String, List<Double>> values, List<ValueInformation> valueInformation) {
        ServerConnectionImpl serverConnectionImpl = this;
        synchronized (serverConnectionImpl) {
            if (!this.queries.containsKey(queryId)) {
                return;
            }
            int len = valueInformation.size();
            if (len < this.getMaxDataSize()) {
                this.sendQueryDataPacket(queryId, index, values, valueInformation);
            } else {
                logger.debug("Using split send: {}", (Object)this.getMaxDataSize());
                int count = 0;
                do {
                    int size = Math.min(len - count, this.getMaxDataSize());
                    logger.debug("Sending - query-id: {}, index: {}, size: {}", new Object[]{queryId, count, size});
                    ArrayList<ValueInformation> vi = new ArrayList<ValueInformation>(valueInformation.subList(count, count + size));
                    HashMap<String, List<Double>> v = new HashMap<String, List<Double>>();
                    for (Map.Entry<String, List<Double>> entry : values.entrySet()) {
                        ArrayList<Double> vs = new ArrayList<Double>(entry.getValue().subList(count, count + size));
                        v.put(entry.getKey(), vs);
                    }
                    this.sendQueryDataPacket(queryId, count, v, vi);
                } while ((count += this.getMaxDataSize()) < len);
            }
        }
    }

    private void sendQueryDataPacket(long queryId, int index, Map<String, List<Double>> values, List<ValueInformation> valueInformation) {
        ArrayList<ValueEntry> data = new ArrayList<ValueEntry>();
        for (Map.Entry<String, List<Double>> entry : values.entrySet()) {
            data.add(new ValueEntry(entry.getKey(), entry.getValue()));
        }
        this.sendMessage(new UpdateQueryData(queryId, index, valueInformation, data));
    }

    public synchronized void sendQueryParameters(long queryId, QueryParameters parameters, Set<String> valueTypes) {
        logger.debug("Sending query parameters: {} / {} / {}", new Object[]{queryId, parameters, valueTypes});
        if (!this.queries.containsKey(queryId)) {
            return;
        }
        this.sendMessage(new UpdateQueryParameters(queryId, parameters, valueTypes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendQueryState(long queryId, QueryState state) {
        logger.debug("Sending query state: {} -> {}", new Object[]{queryId, state});
        ServerConnectionImpl serverConnectionImpl = this;
        synchronized (serverConnectionImpl) {
            if (!this.queries.containsKey(queryId)) {
                logger.info("Query not found {}", (Object)queryId);
                return;
            }
            this.sendMessage(new UpdateQueryState(queryId, state.name()));
        }
    }
}

