/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.proxy.connection;

import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.ConnectionStateListener;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.proxy.connection.ProxyGroup;
import org.eclipse.scada.da.server.proxy.item.ProxyDataItem;

public class NotifyConnectionErrorListener
implements ConnectionStateListener {
    private final ProxyGroup proxyConnection;
    private ConnectionState currentState;
    private Timer timer;

    public NotifyConnectionErrorListener(ProxyGroup proxyConnection) {
        this.proxyConnection = proxyConnection;
    }

    public void stateChange(Connection connection, ConnectionState state, Throwable error) {
        this.currentState = state;
        if (this.proxyConnection.getWait() > 0 && !ConnectionState.BOUND.equals((Object)state)) {
            this.scheduleItemUpdate(state);
        } else {
            this.sendConnectionState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleItemUpdate(final ConnectionState state) {
        NotifyConnectionErrorListener notifyConnectionErrorListener = this;
        synchronized (notifyConnectionErrorListener) {
            if (this.timer == null) {
                this.timer = new Timer();
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        if (!state.equals((Object)NotifyConnectionErrorListener.this.currentState)) {
                            NotifyConnectionErrorListener.this.sendConnectionState(NotifyConnectionErrorListener.this.currentState);
                        }
                        NotifyConnectionErrorListener.this.timer = null;
                    }
                }, this.proxyConnection.getWait());
            }
        }
    }

    private void sendConnectionState(ConnectionState state) {
        for (ProxyDataItem item : this.proxyConnection.getRegisteredItems().values()) {
            HashMap<String, Variant> attrs = new HashMap<String, Variant>();
            if (ConnectionState.BOUND.equals((Object)state)) {
                attrs.put("proxy.error", null);
                attrs.put("proxy.error.message", null);
            } else {
                attrs.put("proxy.error", Variant.TRUE);
                attrs.put("proxy.error.message", Variant.valueOf((Object)("Underlying connection in state " + state)));
            }
            item.updateData(null, attrs, AttributeMode.UPDATE);
        }
    }
}

