/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.client.ngp;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.data.EventInformation;
import org.eclipse.scada.core.Variant;

public final class Events {
    private Events() {
    }

    public static List<Event> convertToEvent(List<EventInformation> events) {
        ArrayList<Event> result = new ArrayList<Event>(events.size());
        for (EventInformation eventInformation : events) {
            result.add(Events.convertToEvent(eventInformation));
        }
        return result;
    }

    public static Event convertToEvent(EventInformation eventInformation) {
        Event.EventBuilder builder = Event.create();
        builder.id(UUID.fromString(eventInformation.getId()));
        builder.sourceTimestamp(new Date(eventInformation.getSourceTimestamp()));
        builder.entryTimestamp(new Date(eventInformation.getEntryTimestamp()));
        for (Map.Entry entry : eventInformation.getAttributes().entrySet()) {
            builder.attribute((String)entry.getKey(), (Variant)entry.getValue());
        }
        return builder.build();
    }
}

