/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.event.logger.internal;

import java.util.Map;
import org.eclipse.scada.core.AttributesHelper;
import org.eclipse.scada.da.client.DataItemValue;

public class DataItemValueDiff {
    private static final DataItemValue DEFAULT_VALUE = DataItemValue.DISCONNECTED;

    public static DataItemValue diff(DataItemValue source, DataItemValue target) {
        DataItemValue.Builder builder = new DataItemValue.Builder();
        if (source == null) {
            source = DEFAULT_VALUE;
        }
        if (target == null) {
            target = DEFAULT_VALUE;
        }
        builder.setValue(DataItemValueDiff.changed(source.getValue(), target.getValue()));
        builder.setSubscriptionState(DataItemValueDiff.changed(source.getSubscriptionState(), target.getSubscriptionState()));
        builder.setAttributes(AttributesHelper.diff((Map)source.getAttributes(), (Map)target.getAttributes()));
        return builder.build();
    }

    private static <T> T changed(T source, T target) {
        if (source == target) {
            return null;
        }
        if (source == null) {
            return target;
        }
        if (target == null) {
            return null;
        }
        if (source.equals(target)) {
            return null;
        }
        return target;
    }
}

