/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.client.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.scada.ae.client.Connection;
import org.eclipse.scada.ae.client.MonitorListener;
import org.eclipse.scada.ae.client.internal.CollectionsBackPort;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.core.data.SubscriptionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorSyncController
implements MonitorListener {
    private static final Logger logger = LoggerFactory.getLogger(MonitorSyncController.class);
    private final List<MonitorListener> listeners = new CopyOnWriteArrayList<MonitorListener>();
    private final Connection connection;
    private final String id;
    private final Set<MonitorStatusInformation> cachedMonitors = CollectionsBackPort.newSetFromMap(new ConcurrentHashMap());

    public MonitorSyncController(Connection connection, String id) {
        if (connection == null) {
            throw new IllegalArgumentException("connection is null");
        }
        this.connection = connection;
        this.id = id;
        this.connection.setMonitorListener(this.id, this);
    }

    @Override
    public void dataChanged(List<MonitorStatusInformation> addedOrUpdated, Set<String> removed, boolean full) {
        if (full) {
            this.cachedMonitors.clear();
        }
        if (addedOrUpdated != null) {
            this.cachedMonitors.removeAll(addedOrUpdated);
            this.cachedMonitors.addAll(addedOrUpdated);
        }
        if (removed != null) {
            HashSet<MonitorStatusInformation> toRemove = new HashSet<MonitorStatusInformation>();
            for (MonitorStatusInformation monitor : this.cachedMonitors) {
                if (!removed.contains(monitor.getId())) continue;
                toRemove.add(monitor);
            }
            for (MonitorStatusInformation monitor : toRemove) {
                this.cachedMonitors.remove(monitor);
            }
        }
        for (MonitorListener listener : this.listeners) {
            listener.dataChanged(addedOrUpdated, removed, full);
        }
    }

    public synchronized void addListener(MonitorListener listener) {
        this.listeners.add(listener);
        listener.dataChanged(new ArrayList<MonitorStatusInformation>(this.cachedMonitors), null, true);
    }

    public synchronized boolean removeListener(MonitorListener listener) {
        this.listeners.remove(listener);
        return this.listeners.size() == 0;
    }

    @Override
    public void statusChanged(SubscriptionState state) {
        this.fireStateChange(state);
        switch (state) {
            case CONNECTED: {
                for (MonitorListener listener : this.listeners) {
                    listener.dataChanged(new ArrayList<MonitorStatusInformation>(this.cachedMonitors), null, true);
                }
                break;
            }
        }
    }

    private void fireStateChange(SubscriptionState state) {
        for (MonitorListener listener : this.listeners) {
            try {
                listener.statusChanged(state);
            }
            catch (Exception e) {
                logger.debug("Failed to notify subscription change", (Throwable)e);
            }
        }
    }

    public void dispose() {
        this.connection.setMonitorListener(this.id, null);
    }
}

