/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.common;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.ca.ConfigurationListener;
import org.eclipse.scada.ca.Factory;
import org.eclipse.scada.ca.common.ConfigurationImpl;
import org.eclipse.scada.ca.data.FactoryState;

public class FactoryImpl
implements Factory {
    private final String id;
    private String description;
    private FactoryState state;
    private final Map<String, ConfigurationImpl> configurations = new TreeMap<String, ConfigurationImpl>();
    private Object service;
    private ConfigurationListener listener;

    public FactoryImpl(String id) {
        this.id = id;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public void setState(FactoryState state) {
        this.state = state;
    }

    public FactoryState getState() {
        return this.state;
    }

    public ConfigurationImpl getConfiguration(String configurationId) {
        return this.configurations.get(configurationId);
    }

    public ConfigurationImpl[] getConfigurations() {
        return this.configurations.values().toArray(new ConfigurationImpl[0]);
    }

    public void setConfigurations(ConfigurationImpl[] configurations) {
        this.configurations.clear();
        ConfigurationImpl[] configurationImplArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationImpl configuration = configurationImplArray[n2];
            this.configurations.put(configuration.getId(), configuration);
            ++n2;
        }
    }

    public void setService(Object service) {
        this.service = service;
    }

    public Object getService() {
        return this.service;
    }

    public ConfigurationFactory getConfigurationFactoryService() {
        Object service = this.service;
        if (service instanceof ConfigurationFactory) {
            return (ConfigurationFactory)service;
        }
        return null;
    }

    public void addConfiguration(ConfigurationImpl configuration) {
        this.configurations.put(configuration.getId(), configuration);
    }

    public void removeConfigration(String configurationId) {
        this.configurations.remove(configurationId);
    }

    public void setListener(ConfigurationListener listener) {
        this.listener = listener;
    }

    public ConfigurationListener getListener() {
        return this.listener;
    }
}

