/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca;

import org.eclipse.scada.ca.Configuration;
import org.eclipse.scada.ca.data.ConfigurationState;

public class ConfigurationEvent {
    private final Configuration configuration;
    private final Type type;
    private final ConfigurationState state;
    private final Throwable error;

    public ConfigurationEvent(Type type, Configuration configuration, ConfigurationState state, Throwable error) {
        this.type = type;
        this.configuration = configuration;
        this.state = state;
        this.error = error;
    }

    public ConfigurationState getState() {
        return this.state;
    }

    public Throwable getError() {
        return this.error;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        switch (this.type) {
            case STATE: {
                return String.format("%s -> %s / %s", new Object[]{this.configuration.getId(), this.type, this.state});
            }
        }
        return String.format("%s -> %s / %s", new Object[]{this.configuration.getId(), this.type, this.configuration});
    }

    public static enum Type {
        CREATED,
        MODIFIED,
        REMOVED,
        STATE;

    }
}

