/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.average;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.DataSourceListener;
import org.eclipse.scada.da.datasource.MultiDataSourceTracker;
import org.eclipse.scada.da.datasource.average.Activator;
import org.eclipse.scada.da.datasource.base.DataInputSource;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AverageDataSource
implements MultiDataSourceTracker.ServiceListener {
    private static final Logger logger = LoggerFactory.getLogger(AverageDataSource.class);
    private final ObjectPoolTracker<DataSource> poolTracker;
    private MultiDataSourceTracker tracker;
    private Set<String> sourceIds;
    private final ConcurrentMap<DataSource, DataSourceHandler> sources = new ConcurrentHashMap<DataSource, DataSourceHandler>();
    private int noOfValidSourcesRequired = 0;
    private final String configurationId;
    private final ObjectPoolImpl<DataSource> dsObjectPool;
    private final DataInputSource sumDataSource;
    private final DataInputSource minDataSource;
    private final DataInputSource maxDataSource;
    private final DataInputSource meanDataSource;
    private final DataInputSource medianDataSource;
    private final DataInputSource deviationDataSource;

    public AverageDataSource(String configurationId, ObjectPoolTracker<DataSource> poolTracker, ExecutorService executor, ObjectPoolImpl<DataSource> dsObjectPool) {
        this.poolTracker = poolTracker;
        this.configurationId = configurationId;
        this.dsObjectPool = dsObjectPool;
        this.sumDataSource = new DataInputSource((Executor)executor);
        this.minDataSource = new DataInputSource((Executor)executor);
        this.maxDataSource = new DataInputSource((Executor)executor);
        this.meanDataSource = new DataInputSource((Executor)executor);
        this.medianDataSource = new DataInputSource((Executor)executor);
        this.deviationDataSource = new DataInputSource((Executor)executor);
        String id = String.valueOf(this.configurationId) + ".min";
        Hashtable<String, String> properties = new Hashtable<String, String>(1);
        ((Dictionary)properties).put("datasource.id", id);
        this.dsObjectPool.addService(id, (Object)this.minDataSource, null);
        id = String.valueOf(this.configurationId) + ".sum";
        properties = new Hashtable(1);
        ((Dictionary)properties).put("datasource.id", id);
        this.dsObjectPool.addService(id, (Object)this.sumDataSource, null);
        id = String.valueOf(this.configurationId) + ".max";
        properties = new Hashtable(1);
        ((Dictionary)properties).put("datasource.id", id);
        this.dsObjectPool.addService(id, (Object)this.maxDataSource, null);
        id = String.valueOf(this.configurationId) + ".mean";
        properties = new Hashtable(1);
        ((Dictionary)properties).put("datasource.id", id);
        this.dsObjectPool.addService(id, (Object)this.meanDataSource, null);
        id = String.valueOf(this.configurationId) + ".median";
        properties = new Hashtable(1);
        ((Dictionary)properties).put("datasource.id", id);
        this.dsObjectPool.addService(id, (Object)this.medianDataSource, null);
        id = String.valueOf(this.configurationId) + ".deviation";
        properties = new Hashtable(1);
        ((Dictionary)properties).put("datasource.id", id);
        this.dsObjectPool.addService(id, (Object)this.deviationDataSource, null);
    }

    public void dispose() {
        this.dsObjectPool.removeService(String.valueOf(this.configurationId) + ".sum", (Object)this.sumDataSource);
        this.dsObjectPool.removeService(String.valueOf(this.configurationId) + ".min", (Object)this.minDataSource);
        this.dsObjectPool.removeService(String.valueOf(this.configurationId) + ".max", (Object)this.maxDataSource);
        this.dsObjectPool.removeService(String.valueOf(this.configurationId) + ".mean", (Object)this.meanDataSource);
        this.dsObjectPool.removeService(String.valueOf(this.configurationId) + ".median", (Object)this.medianDataSource);
        this.dsObjectPool.removeService(String.valueOf(this.configurationId) + ".deviation", (Object)this.deviationDataSource);
        for (DataSourceHandler handler : this.sources.values()) {
            handler.dispose();
        }
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
    }

    public void update(Map<String, String> properties) throws Exception {
        this.setSources(properties.get("sources"));
        this.setValidSourcesRequired(properties.get("validSourcesRequired"));
        this.handleChange();
    }

    private void setSources(String str) throws InvalidSyntaxException {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
        for (DataSourceHandler source : this.sources.values()) {
            source.dispose();
        }
        this.sources.clear();
        this.sourceIds = this.convertSources(str);
        if (this.sourceIds.isEmpty()) {
            return;
        }
        this.tracker = new MultiDataSourceTracker(this.poolTracker, this.sourceIds, (MultiDataSourceTracker.ServiceListener)this);
        this.tracker.open();
    }

    private Set<String> convertSources(String sources) {
        if (sources == null) {
            throw new IllegalArgumentException("'sources' must be set");
        }
        return new LinkedHashSet<String>(Arrays.asList(sources.split("[, ]+")));
    }

    private void setValidSourcesRequired(String validSourcesRequired) {
        if (validSourcesRequired == null || validSourcesRequired.isEmpty()) {
            this.noOfValidSourcesRequired = 0;
            return;
        }
        if (validSourcesRequired.equals("100%")) {
            this.noOfValidSourcesRequired = this.sourceIds.size();
            return;
        }
        try {
            if (validSourcesRequired.endsWith("%")) {
                int percent = Integer.parseInt(validSourcesRequired.replace("%", ""));
                if (percent >= 100) {
                    this.noOfValidSourcesRequired = this.sourceIds.size();
                    return;
                }
                this.noOfValidSourcesRequired = Long.valueOf(Math.round((double)(percent * this.sourceIds.size()) / 100.0)).intValue();
            } else {
                this.noOfValidSourcesRequired = Integer.parseInt(validSourcesRequired);
                if (this.noOfValidSourcesRequired > this.sourceIds.size()) {
                    logger.warn("'validSourcesRequired' was '{}' which should be less then the number of all elements", (Object)validSourcesRequired, (Object)this.sourceIds.size());
                    this.noOfValidSourcesRequired = this.sourceIds.size();
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warn("'validSourcesRequired' was '{}' which could not be parsed", (Object)validSourcesRequired, (Object)e);
            throw e;
        }
    }

    protected void handleChange() {
        ArrayList<Double> validValues = new ArrayList<Double>(this.sources.size());
        int numOfManualValues = 0;
        int numOfErrorValues = 0;
        int numOfDisconnected = 0;
        Double sum = null;
        Double min = null;
        Double max = null;
        Double mean = null;
        Double median = null;
        Double deviation = null;
        for (DataSourceHandler handler : this.sources.values()) {
            DataItemValue div = handler.getValue();
            if (div != null && div.isConnected() && !div.isError()) {
                if (div.getValue() == null || !div.getValue().isNumber()) continue;
                Double d = div.getValue().asDouble(Double.valueOf(0.0));
                Double d2 = min == null ? d : (min = d < min ? d : min);
                max = max == null ? d : (d > max ? d : max);
                sum = sum == null ? d : sum + d;
                validValues.add(d);
                numOfManualValues += div.isManual() ? 1 : 0;
                continue;
            }
            if (div != null && div.isConnected() && div.isError()) {
                ++numOfErrorValues;
                continue;
            }
            if (div != null && div.isConnected()) continue;
            ++numOfDisconnected;
        }
        if (validValues.size() > 0) {
            mean = sum / (double)validValues.size();
            median = (Double)validValues.get(validValues.size() / 2);
            Double dd = 0.0;
            for (Double d : validValues) {
                dd = dd + Math.pow(d - mean, 2.0);
            }
            deviation = Math.sqrt(dd / (double)validValues.size());
        }
        if (validValues.size() < this.noOfValidSourcesRequired) {
            sum = null;
            mean = null;
            median = null;
            deviation = null;
        }
        DataItemValue.Builder divb = new DataItemValue.Builder().setSubscriptionState(SubscriptionState.CONNECTED).setValue(Variant.valueOf((Object)sum));
        this.setAdditionalAttributes(divb, numOfManualValues, numOfErrorValues, numOfDisconnected);
        this.sumDataSource.setValue(divb.build());
        divb = new DataItemValue.Builder().setSubscriptionState(SubscriptionState.CONNECTED).setValue(Variant.valueOf((Object)min));
        this.setAdditionalAttributes(divb, numOfManualValues, numOfErrorValues, numOfDisconnected);
        this.minDataSource.setValue(divb.build());
        divb = new DataItemValue.Builder().setSubscriptionState(SubscriptionState.CONNECTED).setValue(Variant.valueOf((Object)max));
        this.setAdditionalAttributes(divb, numOfManualValues, numOfErrorValues, numOfDisconnected);
        this.maxDataSource.setValue(divb.build());
        divb = new DataItemValue.Builder().setSubscriptionState(SubscriptionState.CONNECTED).setValue(Variant.valueOf((Object)mean));
        this.setAdditionalAttributes(divb, numOfManualValues, numOfErrorValues, numOfDisconnected);
        this.meanDataSource.setValue(divb.build());
        divb = new DataItemValue.Builder().setSubscriptionState(SubscriptionState.CONNECTED).setValue(Variant.valueOf((Object)median));
        this.setAdditionalAttributes(divb, numOfManualValues, numOfErrorValues, numOfDisconnected);
        this.medianDataSource.setValue(divb.build());
        divb = new DataItemValue.Builder().setSubscriptionState(SubscriptionState.CONNECTED).setValue(Variant.valueOf((Object)deviation));
        this.setAdditionalAttributes(divb, numOfManualValues, numOfErrorValues, numOfDisconnected);
        this.deviationDataSource.setValue(divb.build());
    }

    private void setAdditionalAttributes(DataItemValue.Builder divb, int numOfManualValues, int numOfErrorValues, int numOfDisconnected) {
        if (numOfManualValues > 0) {
            divb.setAttribute(String.valueOf(Activator.getContext().getBundle().getSymbolicName()) + ".manual", Variant.valueOf((boolean)true));
        }
        if (this.sources.size() - numOfErrorValues < this.noOfValidSourcesRequired) {
            divb.setAttribute(String.valueOf(Activator.getContext().getBundle().getSymbolicName()) + ".error", Variant.valueOf((boolean)true));
        }
        if (this.sources.size() - numOfDisconnected < this.noOfValidSourcesRequired) {
            divb.setSubscriptionState(SubscriptionState.DISCONNECTED);
        }
    }

    private synchronized void addSource(DataSource dataSource) {
        logger.info("Adding source: {}", new Object[]{dataSource});
        DataSourceHandler handler = new DataSourceHandler(dataSource);
        DataSourceHandler oldHandler = this.sources.put(dataSource, handler);
        if (oldHandler != null) {
            oldHandler.dispose();
        }
        this.handleChange();
    }

    private synchronized void updateSource(DataSource dataSource) {
        logger.info("Updating source: {} / {}", new Object[]{dataSource});
        DataSourceHandler handler = (DataSourceHandler)this.sources.get(dataSource);
        if (handler != null) {
            this.handleChange();
        }
    }

    private synchronized void removeSource(DataSource dataSource) {
        logger.info("Removing source: {}", (Object)dataSource);
        DataSourceHandler handler = (DataSourceHandler)this.sources.remove(dataSource);
        if (handler != null) {
            handler.dispose();
            this.handleChange();
        }
    }

    public void dataSourceAdded(String id, Dictionary<?, ?> properties, DataSource dataSource) {
        this.addSource(dataSource);
    }

    public void dataSourceRemoved(String id, Dictionary<?, ?> properties, DataSource dataSource) {
        this.updateSource(dataSource);
    }

    public void dataSourceModified(String id, Dictionary<?, ?> properties, DataSource dataSource) {
        this.removeSource(dataSource);
    }

    private class DataSourceHandler
    implements DataSourceListener {
        private final DataSource dataSource;
        private DataItemValue value;

        DataSourceHandler(DataSource dataSource) {
            this.dataSource = dataSource;
            dataSource.addListener((DataSourceListener)this);
        }

        public void dispose() {
            this.dataSource.removeListener((DataSourceListener)this);
        }

        public DataItemValue getValue() {
            return this.value;
        }

        public void stateChanged(DataItemValue value) {
            this.value = value;
            AverageDataSource.this.handleChange();
        }
    }
}

