/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.constant;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.da.datasource.constant.ConstantDataSourceFactory;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private ExecutorService executor;
    private ConstantDataSourceFactory factory;
    private ServiceRegistration<ConfigurationFactory> registration;

    public void start(BundleContext context) throws Exception {
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(context.getBundle().getSymbolicName()));
        this.factory = new ConstantDataSourceFactory(context, this.executor);
        Hashtable<String, String> properties = new Hashtable<String, String>(3);
        ((Dictionary)properties).put("service.description", "A constant DA data source");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("factoryId", context.getBundle().getSymbolicName());
        this.registration = context.registerService(ConfigurationFactory.class, (Object)this.factory, properties);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.registration.unregister();
        this.factory.dispose();
        this.executor.shutdown();
    }
}

