/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.proxy.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.DataSourceListener;
import org.eclipse.scada.da.datasource.MultiDataSourceTracker;
import org.eclipse.scada.da.datasource.base.AbstractDataSource;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyDataSource
extends AbstractDataSource
implements MultiDataSourceTracker.ServiceListener {
    private static final Logger logger = LoggerFactory.getLogger(ProxyDataSource.class);
    private final Executor executor;
    private MultiDataSourceTracker tracker;
    private Map<DataSource, SourceHandler> sources = new HashMap<DataSource, SourceHandler>(2);
    private Set<String> sourceIds;
    private final ObjectPoolTracker<DataSource> poolTracker;

    public ProxyDataSource(ObjectPoolTracker<DataSource> poolTracker, Executor executor) {
        this.poolTracker = poolTracker;
        this.executor = executor;
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    public void dispose() {
        for (SourceHandler handler : this.sources.values()) {
            handler.dispose();
        }
        this.sources.clear();
        this.sourceIds.clear();
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
    }

    public void update(Map<String, String> properties) throws Exception {
        this.setSources(properties.get("sources"));
    }

    private void setSources(String str) throws InvalidSyntaxException {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
        this.sourceIds = this.convertSources(str);
        this.sources = new HashMap<DataSource, SourceHandler>(this.sourceIds.size());
        if (this.sourceIds.isEmpty()) {
            return;
        }
        this.tracker = new MultiDataSourceTracker(this.poolTracker, this.sourceIds, (MultiDataSourceTracker.ServiceListener)this);
        this.tracker.open();
    }

    private Set<String> convertSources(String sources) {
        if (sources == null) {
            throw new IllegalArgumentException("'sources' must be set");
        }
        return new LinkedHashSet<String>(Arrays.asList(sources.split("[, ]+")));
    }

    private int getPriority(String id, Dictionary<?, ?> properties) {
        Object o = properties.get("service.ranking");
        if (o == null) {
            return this.getDefaultPriority(id);
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        try {
            return Integer.parseInt(o.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return this.getDefaultPriority(id);
        }
    }

    private int getDefaultPriority(String dataSourceId) {
        int start = 100;
        for (String id : this.sourceIds) {
            if (id != null && id.equals(dataSourceId)) {
                return start;
            }
            --start;
        }
        return Integer.MIN_VALUE;
    }

    protected synchronized void update() {
        ArrayList<DataItemValueEntry> entries = new ArrayList<DataItemValueEntry>(this.sources.size());
        for (SourceHandler handler : this.sources.values()) {
            DataItemValueEntry entry = handler.getEntry();
            if (entry == null || entry.getValue() == null || !entry.getValue().isConnected()) continue;
            entries.add(entry);
        }
        Collections.sort(entries);
        DataItemValue value = entries.isEmpty() ? null : ((DataItemValueEntry)entries.get(entries.size() - 1)).getValue();
        this.updateData(value);
    }

    private synchronized void addSource(DataSource dataSource, int priority) {
        logger.info("Adding source: {} / {}", new Object[]{dataSource, priority});
        SourceHandler handler = new SourceHandler(dataSource, priority);
        SourceHandler oldHandler = this.sources.put(dataSource, handler);
        if (oldHandler != null) {
            oldHandler.dispose();
        }
        this.update();
    }

    private synchronized void updateSource(DataSource dataSource, int priority) {
        logger.info("Updating source: {} / {}", new Object[]{dataSource, priority});
        SourceHandler handler = this.sources.get(dataSource);
        if (handler != null) {
            handler.setPriority(priority);
            this.update();
        }
    }

    private synchronized void removeSource(DataSource dataSource) {
        logger.info("Removing source: {}", (Object)dataSource);
        SourceHandler handler = this.sources.remove(dataSource);
        if (handler != null) {
            handler.dispose();
            this.update();
        }
    }

    public NotifyFuture<WriteAttributeResults> startWriteAttributes(Map<String, Variant> attributes, OperationParameters operationParameters) {
        return new InstantErrorFuture((Throwable)new OperationException("'writeAttributes' not supported"));
    }

    public NotifyFuture<WriteResult> startWriteValue(Variant value, OperationParameters operationParameters) {
        return new InstantErrorFuture((Throwable)new OperationException("'writeAttributes' not supported"));
    }

    public void dataSourceAdded(String id, Dictionary<?, ?> properties, DataSource dataSource) {
        this.addSource(dataSource, this.getPriority(id, properties));
    }

    public void dataSourceModified(String id, Dictionary<?, ?> properties, DataSource dataSource) {
        this.updateSource(dataSource, this.getPriority(id, properties));
    }

    public void dataSourceRemoved(String id, Dictionary<?, ?> properties, DataSource dataSource) {
        this.removeSource(dataSource);
    }

    private class DataItemValueEntry
    implements Comparable<DataItemValueEntry> {
        private final DataItemValue value;
        private final int priority;

        DataItemValueEntry(DataItemValue value, int priority) {
            this.value = value;
            this.priority = priority;
        }

        @Override
        public int compareTo(DataItemValueEntry other) {
            if (this.priority == other.priority) {
                return 0;
            }
            if (this.priority > other.priority) {
                return 1;
            }
            return -1;
        }

        public DataItemValue getValue() {
            return this.value;
        }
    }

    private class SourceHandler
    implements DataSourceListener {
        private final DataSource dataSource;
        private int priority;
        private DataItemValue value;

        SourceHandler(DataSource dataSource, int priority) {
            this.dataSource = dataSource;
            this.priority = priority;
            dataSource.addListener((DataSourceListener)this);
        }

        public void dispose() {
            this.dataSource.removeListener((DataSourceListener)this);
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public DataItemValueEntry getEntry() {
            return new DataItemValueEntry(this.value, this.priority);
        }

        public void stateChanged(DataItemValue value) {
            this.value = value;
            ProxyDataSource.this.update();
        }
    }
}

