/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.script;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.WriteAttributeResult;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.DataSourceHandler;
import org.eclipse.scada.da.datasource.base.AbstractMultiSourceDataSource;
import org.eclipse.scada.da.datasource.script.WriterController;
import org.eclipse.scada.utils.concurrent.FutureTask;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.eclipse.scada.utils.script.ScriptExecutor;
import org.eclipse.scada.utils.script.Scripts;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptDataSource
extends AbstractMultiSourceDataSource {
    private static final String DEFAULT_ENGINE_NAME = System.getProperty("org.eclipse.scada.da.datasource.script.defaultScriptEngine", "JavaScript");
    static final Logger logger = LoggerFactory.getLogger(ScriptDataSource.class);
    private final ScheduledExecutorService executor;
    private final ScriptEngineManager manager;
    private SimpleScriptContext scriptContext;
    private ScriptExecutor updateCommand;
    private ScriptExecutor timerCommand;
    private ScriptEngine scriptEngine;
    private final ClassLoader classLoader;
    private final WriterController writer;
    private ScheduledFuture<?> timer;
    private ScriptExecutor writeCommand;
    private final EventProcessor eventProcessor;

    public ScriptDataSource(BundleContext context, ObjectPoolTracker<DataSource> poolTracker, ScheduledExecutorService executor, EventProcessor eventProcessor) {
        super(poolTracker);
        this.executor = executor;
        this.classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        this.eventProcessor = eventProcessor;
        this.manager = Scripts.createManager((ClassLoader)this.classLoader);
        this.writer = new WriterController(poolTracker);
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    protected Object performWrite(ScriptExecutor command, Variant value, Map<String, Variant> attributes, OperationParameters operationParameters) throws Exception {
        this.scriptContext.setAttribute("value", value, 100);
        this.scriptContext.setAttribute("attributes", attributes, 100);
        this.scriptContext.setAttribute("parameters", operationParameters, 100);
        this.scriptContext.setAttribute("eventProcessor", this.eventProcessor, 100);
        return this.performScript(command, this.scriptContext);
    }

    public NotifyFuture<WriteAttributeResults> startWriteAttributes(final Map<String, Variant> attributes, final OperationParameters operationParameters) {
        final ScriptExecutor writeCommand = this.writeCommand;
        if (writeCommand == null) {
            return new InstantErrorFuture((Throwable)new OperationException("Not supported"));
        }
        FutureTask task = new FutureTask((Callable)new Callable<WriteAttributeResults>(){

            @Override
            public WriteAttributeResults call() throws Exception {
                return ScriptDataSource.this.convertAttributeResult(attributes, ScriptDataSource.this.performWrite(writeCommand, null, attributes, operationParameters));
            }
        });
        this.executor.execute((Runnable)task);
        return task;
    }

    protected WriteAttributeResults convertAttributeResult(Map<String, Variant> attributes, Object result) {
        if (result == null) {
            WriteAttributeResults r = new WriteAttributeResults();
            for (Map.Entry<String, Variant> entry : attributes.entrySet()) {
                r.put((Object)entry.getKey(), (Object)WriteAttributeResult.OK);
            }
            return r;
        }
        if (result instanceof WriteAttributeResults) {
            return (WriteAttributeResults)result;
        }
        if (result instanceof Map) {
            WriteAttributeResults r = new WriteAttributeResults();
            Map map = (Map)result;
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof WriteAttributeResult)) continue;
                r.put((Object)((String)entry.getKey()), (Object)((WriteAttributeResult)entry.getValue()));
            }
            return r;
        }
        WriteAttributeResults r = new WriteAttributeResults();
        for (Map.Entry<String, Variant> entry : attributes.entrySet()) {
            r.put((Object)entry.getKey(), (Object)new WriteAttributeResult((Throwable)new OperationException(String.format("Write attribute result error: %s", result))));
        }
        return r;
    }

    protected WriteResult convertValueResult(Object result) {
        if (result == null) {
            return WriteResult.OK;
        }
        if (result instanceof WriteResult) {
            return (WriteResult)result;
        }
        return new WriteResult((Throwable)new OperationException(String.format("Write error: %s", result)));
    }

    public NotifyFuture<WriteResult> startWriteValue(final Variant value, final OperationParameters operationParameters) {
        final ScriptExecutor writeCommand = this.writeCommand;
        if (writeCommand == null) {
            return new InstantErrorFuture((Throwable)new OperationException("Not supported"));
        }
        FutureTask task = new FutureTask((Callable)new Callable<WriteResult>(){

            @Override
            public WriteResult call() throws Exception {
                return ScriptDataSource.this.convertValueResult(ScriptDataSource.this.performWrite(writeCommand, value, null, operationParameters));
            }
        });
        this.executor.execute((Runnable)task);
        return task;
    }

    public synchronized void update(Map<String, String> parameters) throws Exception {
        this.stopTimer();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
            this.setWriteItems(cfg);
            this.setScript(cfg);
            this.setDataSources(parameters);
            this.startTimer(cfg.getInteger("timer", -1));
            this.handleChange(this.getSourcesCopy());
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private void setWriteItems(ConfigurationDataHelper cfg) {
        this.writer.setWriteItems(cfg.getPrefixed("writeSource."));
    }

    private void startTimer(int period) {
        if (period <= 0) {
            return;
        }
        this.timer = this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ScriptDataSource.this.handleTimer();
            }
        }, period, period, TimeUnit.MILLISECONDS);
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel(false);
            this.timer = null;
        }
    }

    public void dispose() {
        this.stopTimer();
        super.dispose();
    }

    private void setScript(ConfigurationDataHelper cfg) throws ScriptException {
        String engine = cfg.getString("engine", DEFAULT_ENGINE_NAME);
        if ("".equals(engine)) {
            engine = DEFAULT_ENGINE_NAME;
        }
        this.scriptContext = new SimpleScriptContext();
        this.scriptEngine = this.manager.getEngineByName(engine);
        if (this.scriptEngine == null) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid script engine", engine));
        }
        String initScript = cfg.getString("init");
        if (initScript != null) {
            this.scriptEngine.eval(initScript, (ScriptContext)this.scriptContext);
        }
        this.updateCommand = this.makeScript(cfg.getString("updateCommand"));
        this.timerCommand = this.makeScript(cfg.getString("timerCommand"));
        this.writeCommand = this.makeScript(cfg.getString("writeCommand"));
    }

    private ScriptExecutor makeScript(String string) throws ScriptException {
        if (string == null || string.isEmpty()) {
            return null;
        }
        return new ScriptExecutor(this.scriptEngine, string, this.classLoader);
    }

    protected synchronized void handleTimer() {
        this.scriptContext.setAttribute("writer", this.writer, 100);
        this.scriptContext.setAttribute("eventProcessor", this.eventProcessor, 100);
        this.executeScript(this.timerCommand);
    }

    protected synchronized void handleChange(Map<String, DataSourceHandler> sources) {
        HashMap<String, DataItemValue> values = new HashMap<String, DataItemValue>();
        for (Map.Entry<String, DataSourceHandler> entry : sources.entrySet()) {
            values.put(entry.getKey(), entry.getValue().getValue());
        }
        this.scriptContext.setAttribute("data", values, 100);
        this.scriptContext.setAttribute("writer", this.writer, 100);
        this.scriptContext.setAttribute("eventProcessor", this.eventProcessor, 100);
        this.executeScript(this.updateCommand);
    }

    protected Object performScript(ScriptExecutor command, ScriptContext scriptContext) throws Exception {
        return command.execute(scriptContext);
    }

    protected void executeScript(ScriptExecutor command) {
        if (command == null) {
            return;
        }
        try {
            this.setResult(this.performScript(command, this.scriptContext));
        }
        catch (Throwable e) {
            logger.warn("Failed to evaluate", e);
            logger.debug("Failed script: {}", (Object)command);
            this.setError(e);
        }
    }

    private synchronized void setError(Throwable e) {
        DataItemValue.Builder builder = new DataItemValue.Builder();
        builder.setValue(Variant.NULL);
        builder.setTimestamp(Calendar.getInstance());
        builder.setAttribute("script.error", Variant.TRUE);
        builder.setAttribute("script.error.message", Variant.valueOf((Object)e.getMessage()));
        this.updateData(builder.build());
    }

    private synchronized void setResult(Object result) {
        logger.debug("Setting result: {}", result);
        if (result instanceof DataItemValue.Builder) {
            logger.debug("Using builder");
            this.updateData(((DataItemValue.Builder)result).build());
        } else if (result instanceof DataItemValue) {
            logger.debug("Using data item value");
            this.updateData((DataItemValue)result);
        } else {
            logger.debug("Falling back to plain value");
            DataItemValue.Builder builder = new DataItemValue.Builder();
            builder.setSubscriptionState(SubscriptionState.CONNECTED);
            builder.setValue(Variant.valueOf((Object)result));
            this.updateData(builder.build());
        }
    }
}

