/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.browser.common.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.core.browser.Entry;
import org.eclipse.scada.da.core.server.browser.NoSuchFolderException;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.browser.common.FolderListener;
import org.eclipse.scada.da.server.browser.common.query.ItemDescriptor;
import org.eclipse.scada.da.server.browser.common.query.Matcher;
import org.eclipse.scada.da.server.browser.common.query.NameProvider;
import org.eclipse.scada.da.server.browser.common.query.StorageBasedFolder;
import org.eclipse.scada.da.server.common.DataItem;

public class QueryFolder
implements StorageBasedFolder {
    private Matcher _matcher = null;
    private NameProvider _nameProvider = null;
    private final FolderCommon _folder = new FolderCommon();
    private final List<StorageBasedFolder> _folders = new ArrayList<StorageBasedFolder>();
    private final Set<ItemDescriptor> _items = new HashSet<ItemDescriptor>();

    public QueryFolder(Matcher matcher, NameProvider nameProvider) {
        this._matcher = matcher;
        this._nameProvider = nameProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(String name, StorageBasedFolder folder, Map<String, Variant> attributes) {
        QueryFolder queryFolder = this;
        synchronized (queryFolder) {
            this._folder.add(name, folder, attributes);
            this._folders.add(folder);
            for (ItemDescriptor desc : this._items) {
                folder.added(desc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(QueryFolder folder) {
        QueryFolder queryFolder = this;
        synchronized (queryFolder) {
            this._folder.remove(folder);
            this._folders.remove(folder);
        }
    }

    private boolean match(ItemDescriptor desc) {
        if (this._matcher != null) {
            return this._matcher.matches(desc);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void added(ItemDescriptor desc) {
        QueryFolder queryFolder = this;
        synchronized (queryFolder) {
            if (this._items.contains(desc)) {
                return;
            }
            if (this.match(desc)) {
                this._items.add(desc);
                this.notifyAdd(desc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removed(ItemDescriptor desc) {
        QueryFolder queryFolder = this;
        synchronized (queryFolder) {
            if (!this._items.contains(desc)) {
                return;
            }
            this._items.remove(desc);
            this.notifyRemove(desc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllForItem(DataItem dataItem) {
        QueryFolder queryFolder = this;
        synchronized (queryFolder) {
            LinkedList<ItemDescriptor> removeList = new LinkedList<ItemDescriptor>();
            for (ItemDescriptor desc : this._items) {
                if (desc.getItem() != dataItem) continue;
                removeList.add(desc);
            }
            for (ItemDescriptor desc : removeList) {
                this.removed(desc);
            }
        }
    }

    private void notifyAdd(ItemDescriptor desc) {
        String name = this._nameProvider.getName(desc);
        if (name != null) {
            this._folder.add(name, desc.getItem(), desc.getAttributes());
        }
        for (StorageBasedFolder folder : this._folders) {
            folder.added(desc);
        }
    }

    private void notifyRemove(ItemDescriptor desc) {
        String name = this._nameProvider.getName(desc);
        if (name != null) {
            this._folder.remove(desc.getItem());
        }
        for (StorageBasedFolder folder : this._folders) {
            folder.removed(desc);
        }
    }

    @Override
    public Entry[] list(Stack<String> path) throws NoSuchFolderException {
        return this._folder.list(path);
    }

    @Override
    public void subscribe(Stack<String> path, FolderListener listener, Object tag) throws NoSuchFolderException {
        this._folder.subscribe(path, listener, tag);
    }

    @Override
    public void unsubscribe(Stack<String> path, Object tag) throws NoSuchFolderException {
        this._folder.unsubscribe(path, tag);
    }

    @Override
    public void added() {
        this._folder.added();
    }

    @Override
    public void removed() {
        this._folder.removed();
    }
}

