/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.exporter;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.exporter.AbstractObjectExporter;
import org.eclipse.scada.da.server.common.item.factory.ItemFactory;
import org.eclipse.scada.utils.lang.Disposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectExporter
extends AbstractObjectExporter
implements PropertyChangeListener,
Disposable {
    private static final Logger logger = LoggerFactory.getLogger(ObjectExporter.class);
    private Object target;
    private boolean bound;
    private Map<String, Variant> additionalAttributes;

    public ObjectExporter(ItemFactory itemFactory) {
        this(itemFactory, false, false);
    }

    public ObjectExporter(ItemFactory itemFactory, boolean readOnly, boolean nullIsError, String prefix) {
        super(itemFactory, readOnly, nullIsError, prefix);
    }

    public ObjectExporter(ItemFactory itemFactory, boolean readOnly, boolean nullIsError) {
        this(itemFactory, readOnly, nullIsError, null);
    }

    public synchronized void attachTarget(Object target) {
        this.detachTarget();
        this.target = target;
        if (target == null) {
            return;
        }
        Method m = this.getEventMethod("addPropertyChangeListener");
        try {
            m.invoke(this.target, this);
            this.bound = true;
        }
        catch (Throwable e) {
            logger.info("Failed to add property listener", e);
        }
        this.createDataItems(target.getClass());
    }

    public synchronized void setAttributes(Map<String, Variant> additionalAttributes) {
        this.additionalAttributes = additionalAttributes != null ? Collections.unmodifiableMap(additionalAttributes) : null;
        this.updateItemsFromTarget();
    }

    @Override
    protected Map<String, Variant> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    @Override
    protected void fillAttributes(PropertyDescriptor pd, Map<String, Variant> attributes) {
        super.fillAttributes(pd, attributes);
        attributes.put("exporter.bound", Variant.valueOf((boolean)this.bound));
    }

    public synchronized void detachTarget() {
        if (this.target == null) {
            return;
        }
        if (this.bound) {
            Method m = this.getEventMethod("removePropertyChangeListener");
            try {
                m.invoke(this.target, this);
            }
            catch (Throwable e) {
                logger.info("Failed to dispose listener", e);
            }
        }
        this.items.clear();
        this.attributes.clear();
        this.factory.disposeAllItems();
        this.target = null;
        this.bound = false;
    }

    @Override
    public void dispose() {
        this.detachTarget();
        super.dispose();
    }

    protected Method getEventMethod(String methodName) {
        try {
            return this.target.getClass().getMethod(methodName, PropertyChangeListener.class);
        }
        catch (SecurityException e) {
            logger.info("Failed to get add method", (Throwable)e);
            return null;
        }
        catch (NoSuchMethodException e) {
            logger.info("Failed to get add method", (Throwable)e);
            return null;
        }
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        this.updateAttribute(evt.getPropertyName(), evt.getNewValue(), null, null);
    }

    @Override
    protected Object getTarget() {
        return this.target;
    }
}

