/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exec.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.DataItemCommand;
import org.eclipse.scada.da.server.exec.Hive;
import org.eclipse.scada.da.server.exec.StatusCodes;
import org.eclipse.scada.da.server.exec.command.AbstractSingleCommand;
import org.eclipse.scada.da.server.exec.command.ProcessConfiguration;
import org.eclipse.scada.da.server.exec.command.ProcessListener;
import org.eclipse.scada.da.server.exec.extractor.Extractor;
import org.eclipse.scada.utils.statuscodes.CodedRuntimeException;

public class TriggerCommand
extends AbstractSingleCommand
implements DataItemCommand.Listener,
ProcessListener {
    private final String argumentPlaceholder;
    private final boolean skipIfNull;
    private DataItemCommand startItem;
    private final boolean fork;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private volatile Process currentProcess;
    private DataItemCommand killItem;

    public TriggerCommand(String id, ProcessConfiguration processConfiguration, Collection<Extractor> extractors, String argumentPlaceholder, boolean skipIfNull, boolean fork) {
        super(id, processConfiguration, extractors);
        this.argumentPlaceholder = argumentPlaceholder;
        this.skipIfNull = skipIfNull;
        this.fork = fork;
    }

    @Override
    public void register(Hive hive, FolderCommon parentFolder) {
        super.register(hive, parentFolder);
        this.startItem = this.getItemFactory().createCommand("start", null);
        this.startItem.addListener((DataItemCommand.Listener)this);
        this.killItem = this.getItemFactory().createCommand("kill", null);
        this.killItem.addListener(new DataItemCommand.Listener(){

            public void command(Variant value) throws Exception {
                TriggerCommand.this.kill();
            }
        });
    }

    public void command(Variant value) throws Exception {
        if (!this.running.compareAndSet(false, true)) {
            throw new CodedRuntimeException(StatusCodes.TRIGGER_RUNNING, "Operation is already running");
        }
        this.start(value);
    }

    private void start(Variant value) {
        final ProcessBuilder pb = this.mergeValue(this.processConfiguration.asProcessBuilder(), value);
        if (this.fork) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    TriggerCommand.this.execute(pb, TriggerCommand.this);
                }
            });
            thread.start();
        } else {
            this.execute(pb, this);
        }
    }

    private ProcessBuilder mergeValue(ProcessBuilder pb, Variant value) {
        if (this.argumentPlaceholder == null) {
            return pb;
        }
        List<String> command = pb.command();
        ArrayList<String> newCommand = new ArrayList<String>();
        int i = 0;
        while (i < command.size()) {
            String entry = command.get(i);
            if (i != 0 && entry.contains(this.argumentPlaceholder)) {
                if (value.isNull() && this.skipIfNull) {
                    entry = null;
                } else {
                    String str = value.asString("");
                    entry = entry.replace(this.argumentPlaceholder, str);
                }
            }
            if (entry != null) {
                newCommand.add(entry);
            }
            ++i;
        }
        pb.command(newCommand);
        return pb;
    }

    protected void kill() {
        Process p = this.currentProcess;
        if (p == null) {
            return;
        }
        p.destroy();
    }

    @Override
    public void processCompleted() {
        this.running.set(false);
        this.currentProcess = null;
    }

    @Override
    public void processCreated(Process process) {
        this.currentProcess = process;
    }
}

