/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.proxy.connection;

import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.client.AutoReconnectController;
import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.ConnectionStateListener;
import org.eclipse.scada.da.client.FolderManager;
import org.eclipse.scada.da.client.ItemManager;
import org.eclipse.scada.da.client.ItemManagerImpl;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.DataItemCommand;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.da.server.common.item.factory.FolderItemFactory;
import org.eclipse.scada.da.server.proxy.Hive;
import org.eclipse.scada.da.server.proxy.utils.ProxyPrefixName;
import org.eclipse.scada.da.server.proxy.utils.ProxySubConnectionId;

public class ProxySubConnection
implements ConnectionStateListener {
    private final org.eclipse.scada.da.client.Connection connection;
    private final ItemManager itemManager;
    private final ProxyPrefixName prefix;
    private final ProxySubConnectionId id;
    private final FolderManager folderManager;
    private final Hive hive;
    private final FolderItemFactory itemFactory;
    private final DataItemInputChained stateItem;
    private final DataItemCommand connectItem;
    private final DataItemCommand disconnectItem;
    private final AutoReconnectController controller;

    public ProxySubConnection(org.eclipse.scada.da.client.Connection connection, ProxyPrefixName parentName, ProxySubConnectionId id, ProxyPrefixName prefix, Hive hive, FolderCommon connectionFolder) {
        this.connection = connection;
        this.itemManager = new ItemManagerImpl(this.connection);
        this.folderManager = new FolderManager(this.connection);
        this.prefix = prefix;
        this.id = id;
        this.hive = hive;
        this.itemFactory = new FolderItemFactory((HiveCommon)this.hive, connectionFolder, String.valueOf(parentName.getName()) + ".connections." + id, id.getName());
        this.stateItem = this.itemFactory.createInput("state", null);
        this.connection.addConnectionStateListener((ConnectionStateListener)this);
        this.connectItem = this.itemFactory.createCommand("connect", null);
        this.connectItem.addListener(new DataItemCommand.Listener(){

            public void command(Variant value) throws Exception {
                ProxySubConnection.this.connect();
            }
        });
        this.disconnectItem = this.itemFactory.createCommand("disconnect", null);
        this.disconnectItem.addListener(new DataItemCommand.Listener(){

            public void command(Variant value) throws Exception {
                ProxySubConnection.this.disconnect();
            }
        });
        this.controller = new AutoReconnectController((Connection)this.connection);
        this.connect();
    }

    protected void disconnect() {
        this.controller.disconnect();
    }

    protected void connect() {
        this.controller.connect();
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public org.eclipse.scada.da.client.Connection getConnection() {
        return this.connection;
    }

    public ProxyPrefixName getPrefix() {
        return this.prefix;
    }

    public ProxySubConnectionId getId() {
        return this.id;
    }

    public FolderManager getFolderManager() {
        return this.folderManager;
    }

    public void dispose() {
        this.disconnect();
        this.itemFactory.dispose();
    }

    public void stateChange(Connection connection, ConnectionState state, Throwable error) {
        this.stateItem.updateData(Variant.valueOf((Object)state.toString()), null, null);
    }
}

