/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.test.items;

import java.util.EnumSet;
import java.util.HashMap;
import org.eclipse.scada.core.InvalidOperationException;
import org.eclipse.scada.core.NotConvertableException;
import org.eclipse.scada.core.NullValueException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.core.DataItemInformation;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.DataItemInformationBase;
import org.eclipse.scada.da.server.common.chain.ChainItem;
import org.eclipse.scada.da.server.common.chain.MemoryItemChained;
import org.eclipse.scada.da.server.common.chain.item.SumErrorChainItem;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public class TestItem2
extends MemoryItemChained {
    public TestItem2(HiveCommon hive, String id) {
        super((DataItemInformation)new DataItemInformationBase(id, EnumSet.of(IODirection.INPUT, IODirection.OUTPUT)));
        this.addChainElement(IODirection.INPUT, (ChainItem)new SumErrorChainItem());
    }

    protected NotifyFuture<WriteResult> startWriteCalculatedValue(Variant value, OperationParameters operationParameters) {
        try {
            this.performWriteValue(value, operationParameters);
            return new InstantFuture((Object)new WriteResult());
        }
        catch (Throwable e) {
            return new InstantErrorFuture(e);
        }
    }

    protected synchronized void performWriteValue(Variant value, OperationParameters operationParameters) throws InvalidOperationException, NullValueException, NotConvertableException {
        HashMap<String, Variant> attr = new HashMap<String, Variant>();
        if (value.isNull()) {
            attr.put("test.error", null);
        } else {
            attr.put("test.error", Variant.valueOf((Object)value));
        }
        this.updateData(null, attr, AttributeMode.UPDATE);
    }
}

