/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.data.ValueInformation;
import org.eclipse.scada.net.base.data.DoubleValue;
import org.eclipse.scada.net.base.data.IntegerValue;
import org.eclipse.scada.net.base.data.ListValue;
import org.eclipse.scada.net.base.data.LongValue;
import org.eclipse.scada.net.base.data.MapValue;
import org.eclipse.scada.net.base.data.StringValue;
import org.eclipse.scada.net.base.data.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHelper {
    private static final Logger logger = LoggerFactory.getLogger(QueryHelper.class);

    public static Value toValue(QueryParameters parameters) {
        MapValue value = new MapValue();
        if (parameters == null) {
            return null;
        }
        value.put("startTimestamp", (Value)new LongValue(parameters.getStartTimestamp()));
        value.put("endTimestamp", (Value)new LongValue(parameters.getEndTimestamp()));
        value.put("numberOfEntries", (Value)new IntegerValue(parameters.getNumberOfEntries()));
        return value;
    }

    public static QueryParameters fromValue(Value value) {
        try {
            MapValue map = (MapValue)value;
            long startTimestamp = ((LongValue)map.get("startTimestamp")).getValue();
            long endTimestamp = ((LongValue)map.get("endTimestamp")).getValue();
            int numberOfEntries = ((IntegerValue)map.get("numberOfEntries")).getValue();
            return new QueryParameters(startTimestamp, endTimestamp, numberOfEntries);
        }
        catch (ClassCastException e) {
            logger.debug("Failed to decode", (Throwable)e);
            return null;
        }
        catch (NullPointerException e) {
            logger.debug("Failed to decode", (Throwable)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            logger.debug("Failed to decode", (Throwable)e);
            return null;
        }
    }

    public static Map<String, List<Double>> fromValueData(Value value) {
        HashMap<String, List<Double>> result = new HashMap<String, List<Double>>();
        MapValue map = (MapValue)value;
        for (Map.Entry entry : map.getValues().entrySet()) {
            result.put((String)entry.getKey(), QueryHelper.fromValues((Value)entry.getValue()));
        }
        return result;
    }

    private static List<Double> fromValues(Value value) {
        ListValue list = (ListValue)value;
        ArrayList<Double> result = new ArrayList<Double>(list.size());
        for (Value entry : list.getValues()) {
            if (entry instanceof LongValue) {
                result.add(Double.valueOf(((LongValue)entry).getValue()));
                continue;
            }
            result.add(((DoubleValue)entry).getValue());
        }
        return result;
    }

    public static Value toValueData(Map<String, List<Double>> values) {
        MapValue result = new MapValue();
        for (Map.Entry<String, List<Double>> entry : values.entrySet()) {
            result.put(entry.getKey(), QueryHelper.toValues(entry.getValue()));
        }
        return result;
    }

    private static Value toValues(List<Double> value) {
        ListValue list = new ListValue();
        for (Double entry : value) {
            list.add((Value)new DoubleValue(entry.doubleValue()));
        }
        return list;
    }

    public static List<ValueInformation> fromValueInfo(Value value) {
        LinkedList<ValueInformation> result = new LinkedList<ValueInformation>();
        try {
            ListValue listValue = (ListValue)value;
            for (Value entry : listValue.getValues()) {
                result.add(QueryHelper.fromEntry(entry));
            }
        }
        catch (ClassCastException e) {
            logger.debug("Failed to decode", (Throwable)e);
            return null;
        }
        catch (NullPointerException e) {
            logger.debug("Failed to decode", (Throwable)e);
            return null;
        }
        return result;
    }

    private static ValueInformation fromEntry(Value entry) {
        MapValue value = (MapValue)entry;
        double quality = ((DoubleValue)value.get("quality")).getValue();
        double manualPercentage = ((DoubleValue)value.get("manual")).getValue();
        long startTimestamp = ((LongValue)value.get("startTimestamp")).getValue();
        long endTimestamp = ((LongValue)value.get("endTimestamp")).getValue();
        long sourceValues = ((LongValue)value.get("values")).getValue();
        return new ValueInformation(quality, manualPercentage, startTimestamp, endTimestamp, sourceValues);
    }

    public static Value toValueInfo(List<ValueInformation> infos) {
        ListValue result = new ListValue();
        for (ValueInformation info : infos) {
            MapValue entry = new MapValue();
            entry.put("startTimestamp", (Value)new LongValue(info.getStartTimestamp()));
            entry.put("endTimestamp", (Value)new LongValue(info.getEndTimestamp()));
            entry.put("quality", (Value)new DoubleValue(info.getQuality()));
            entry.put("manual", (Value)new DoubleValue(info.getManualPercentage()));
            entry.put("values", (Value)new LongValue(info.getSourceValues()));
            result.add((Value)entry);
        }
        return result;
    }

    public static Value toValueTypes(Set<String> valueTypes) {
        ListValue result = new ListValue();
        for (String entry : valueTypes) {
            result.add((Value)new StringValue(entry));
        }
        return result;
    }

    public static Set<String> fromValueTypes(Value value) {
        HashSet<String> result = new HashSet<String>();
        try {
            ListValue list = (ListValue)value;
            for (Value valueEntry : list.getValues()) {
                result.add(((StringValue)valueEntry).getValue());
            }
        }
        catch (NullPointerException e) {
            logger.debug("Failed to decode", (Throwable)e);
        }
        catch (ClassCastException e) {
            logger.debug("Failed to decode", (Throwable)e);
        }
        return result;
    }
}

