/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.authz.signature;

import java.io.InputStream;
import java.net.URL;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CA {
    private static final Logger logger = LoggerFactory.getLogger(X509CA.class);
    private volatile X509Certificate[] certificates;
    private volatile X509CRL[] crls;
    private final String certificateUrl;
    private final Collection<String> crlUrls;
    private final CertificateFactory certificateFactory;

    public X509CA(CertificateFactory cf, String certificateUrl, Collection<String> crlUrls) {
        this.certificateFactory = cf;
        this.certificateUrl = certificateUrl;
        this.crlUrls = crlUrls != null ? new ArrayList<String>(crlUrls) : null;
        this.certificates = new X509Certificate[0];
        this.crls = new X509CRL[0];
    }

    public void load() throws Exception {
        Collection<X509Certificate> certificates = this.loadCert(this.certificateUrl);
        Collection<X509CRL> crls = this.loadCrl(this.crlUrls);
        this.certificates = certificates.toArray(new X509Certificate[certificates.size()]);
        this.crls = crls.toArray(new X509CRL[crls.size()]);
    }

    private Collection<X509CRL> loadCrl(Collection<String> crls) throws Exception {
        if (crls == null || crls.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<X509CRL> result = new LinkedList<X509CRL>();
        for (String crl : crls) {
            logger.info("Loading CA CRL from : {}", (Object)crl);
            InputStream stream = new URL(crl).openStream();
            try {
                Collection<? extends CRL> crlData = this.certificateFactory.generateCRLs(stream);
                logger.debug("Loaded {} entries", crlData);
                result.addAll(crlData);
            }
            finally {
                stream.close();
            }
        }
        logger.info("Finished loading CRLs - {} found", (Object)result.size());
        return result;
    }

    private Collection<X509Certificate> loadCert(String value) throws Exception {
        logger.info("Loading CA cert from : {}", (Object)value);
        InputStream stream = new URL(value).openStream();
        try {
            Collection<? extends Certificate> result = this.certificateFactory.generateCertificates(stream);
            logger.info("Finished loading CA certs - {} found", (Object)result.size());
            Collection<? extends Certificate> collection = result;
            return collection;
        }
        finally {
            stream.close();
        }
    }

    public X509Certificate[] getCertificates() {
        return this.certificates;
    }

    public X509CRL[] getCrls() {
        return this.crls;
    }

    public boolean isRevoked(X509Certificate cert) {
        X509CRL[] x509CRLArray = this.crls;
        int n = this.crls.length;
        int n2 = 0;
        while (n2 < n) {
            X509CRL crl = x509CRLArray[n2];
            if (crl.isRevoked(cert)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isValid() {
        X509Certificate[] x509CertificateArray = this.certificates;
        int n = this.certificates.length;
        int n2 = 0;
        while (n2 < n) {
            X509Certificate cert = x509CertificateArray[n2];
            try {
                cert.checkValidity();
                return true;
            }
            catch (Exception exception) {
                ++n2;
            }
        }
        return false;
    }

    public String toString() {
        return String.format("[CA - cert: {}, crls: {}]", this.certificateUrl, this.crlUrls);
    }
}

